/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.aktin.broker.Authenticated;
import org.aktin.broker.RequestBundleExport;
import org.aktin.broker.RequireAdmin;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.download.Download;
import org.aktin.broker.download.DownloadManager;
import org.aktin.broker.server.DateDataSource;
import org.aktin.broker.xml.ResultList;

@Path(value="/aggregator/")
public class AggregatorEndpoint {
    private static final Logger log = Logger.getLogger(AggregatorEndpoint.class.getName());
    public static final String SERVICE_URL = "/aggregator/";
    @Inject
    private AggregatorBackend db;
    @Inject
    private DownloadManager downloads;

    private boolean isRequestWritable(int requestId, int nodeId) {
        return true;
    }

    @Authenticated
    @PUT
    @Path(value="my/request/{id}/result")
    public Response submitResult(@PathParam(value="id") String requestId, @Context HttpHeaders headers, @Context SecurityContext sec, InputStream content) throws URISyntaxException {
        Principal user = (Principal)sec.getUserPrincipal();
        MediaType type = headers.getMediaType();
        log.info("Result received from node " + user.getNodeId() + ": " + type.toString());
        int request = Integer.parseInt(requestId);
        if (!this.isRequestWritable(request, user.getNodeId())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            this.db.addOrReplaceResult(request, user.getNodeId(), type, content);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to persist data", e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @RequireAdmin
    @GET
    @Path(value="request/{id}/result")
    @Produces(value={"application/xml"})
    public Response listResultsForRequest(@PathParam(value="id") String requestId) {
        List results;
        int request = Integer.parseInt(requestId);
        try {
            results = this.db.listResults(request);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to list results from database", e);
            return Response.serverError().build();
        }
        log.info("Found " + results.size() + " results");
        return Response.ok((Object)new ResultList(results)).build();
    }

    @RequireAdmin
    @GET
    @Produces(value={"text/plain"})
    @Path(value="request/{id}/result/{nodeId}")
    public String listResultsForRequest(@PathParam(value="id") String requestId, @PathParam(value="nodeId") String nodeId) {
        DateDataSource data;
        int request = Integer.parseInt(requestId);
        int node = Integer.parseInt(nodeId);
        try {
            data = this.db.getResult(request, node);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to retrieve data", e);
            throw new InternalServerErrorException((Throwable)e);
        }
        if (data == null) {
            throw new NotFoundException();
        }
        String ext = RequestBundleExport.guessFileExtension(data.getContentType());
        if (ext == null) {
            ext = "";
        }
        Download download = this.downloads.createDataSourceDownload((DataSource)data, requestId + "_result_" + nodeId + ext);
        return download.getId().toString();
    }
}

