/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker;

import java.io.IOException;
import java.sql.Date;
import java.util.UUID;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.aktin.broker.download.Download;
import org.aktin.broker.download.DownloadManager;

@Path(value="/broker/download")
public class DownloadEndpoint {
    private static final Logger log = Logger.getLogger(DownloadEndpoint.class.getName());
    @Inject
    DownloadManager downloads;

    @GET
    @Path(value="{id}")
    public Response download(@PathParam(value="id") String id) throws IOException {
        Long contentLength;
        Download download;
        UUID uuid;
        System.err.println("Download requested for " + id);
        try {
            uuid = UUID.fromString(id);
            download = this.downloads.get(uuid);
        }
        catch (IllegalArgumentException e) {
            log.warning("Failed to parse UUID");
            download = null;
            uuid = null;
        }
        if (download == null) {
            log.info("No download found with UUID " + uuid);
            throw new NotFoundException();
        }
        Response.ResponseBuilder rb = Response.ok((Object)download.getInputStream(), (String)download.getContentType());
        if (download.getLastModified() != null) {
            rb.lastModified(Date.from(download.getLastModified()));
        }
        if ((contentLength = download.getContentLength()) != null) {
            rb.header("Content-Length", (Object)contentLength);
        }
        if (download.getName() != null) {
            rb.header("Content-Disposition", (Object)("inline; filename=\"" + download.getName() + "\""));
        }
        return rb.build();
    }
}

