/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.xml.bind.JAXBException;
import org.aktin.broker.RequestBundleExport;
import org.aktin.broker.RequireAdmin;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.download.Download;
import org.aktin.broker.download.DownloadManager;

@RequireAdmin
@Path(value="/broker/export")
public class ExportEndpoint {
    @Inject
    private BrokerBackend broker;
    @Inject
    private AggregatorBackend aggregator;
    @Inject
    private DownloadManager downloads;

    @GET
    @Path(value="request-bundle/{id}")
    @Produces(value={"text/plain"})
    public String downloadBundle(@PathParam(value="id") int requestId) throws IOException, JAXBException {
        RequestBundleExport export = new RequestBundleExport(this.broker);
        export.setAggregator(this.aggregator);
        Download d = this.downloads.createTemporaryFile("application/zip", "export_" + Integer.toString(requestId) + ".zip");
        export.createBundle(requestId, d.getOutputStream());
        return d.getId().toString();
    }
}

