/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.Flushable;
import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.xml.Node;

@Singleton
public class AuthCache
implements Flushable {
    private Map<String, Principal> cache = new HashMap<String, Principal>();
    private BrokerBackend backend;

    public AuthCache() {
    }

    @Inject
    public AuthCache(BrokerBackend backend) {
        this();
        this.setBackend(backend);
    }

    private void setBackend(BrokerBackend backend) {
        this.backend = backend;
    }

    public Principal getPrincipal(String nodeKey, String clientDn) throws SQLException {
        Objects.requireNonNull(clientDn);
        Principal p = this.cache.get(nodeKey);
        if (p == null) {
            p = this.backend.accessPrincipal(nodeKey, clientDn);
            this.cache.put(nodeKey, p);
        }
        p.updateLastAccessed();
        return p;
    }

    public void fillCachedAccessTimestamps(Iterable<Node> nodes) {
        HashMap<Integer, Long> timestamps = new HashMap<Integer, Long>();
        for (Principal p : this.cache.values()) {
            timestamps.put(p.getNodeId(), p.getLastAccessed());
        }
        for (Node node : nodes) {
            Long ts = (Long)timestamps.get(node.id);
            if (ts == null) continue;
            node.lastContact = Instant.ofEpochMilli(ts);
        }
    }

    @Override
    @PreDestroy
    public void flush() throws IOException {
        int[] nodeIds = new int[this.cache.size()];
        long[] timestamps = new long[this.cache.size()];
        int i = 0;
        for (Principal p : this.cache.values()) {
            nodeIds[i] = p.getNodeId();
            timestamps[i] = p.getLastAccessed();
        }
        try {
            this.backend.updateNodeLastSeen(nodeIds, timestamps);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

