/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import org.aktin.broker.PathDataSource;
import org.aktin.broker.download.AbstractDownload;
import org.aktin.broker.server.DateDataSource;

public class DataSourceDownload
extends AbstractDownload {
    private static final Logger log = Logger.getLogger(DataSourceDownload.class.getName());
    private DataSource ds;
    private boolean deletePath;
    private String name;

    public DataSourceDownload(DataSource ds) {
        this.ds = ds;
    }

    public DataSourceDownload(PathDataSource ds, boolean deletePath) {
        this((DataSource)ds);
        this.deletePath = deletePath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Instant getLastModified() {
        if (this.ds instanceof DateDataSource) {
            return ((DateDataSource)this.ds).getLastModified();
        }
        return null;
    }

    public String getContentType() {
        return this.ds.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.ds.getInputStream();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.ds.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.ds.getOutputStream();
    }

    @Override
    void postRemovalCleanup() {
        if (this.deletePath) {
            if (!(this.ds instanceof PathDataSource)) {
                throw new IllegalStateException("deletePath=true but unexpected data source class " + this.ds.getClass().getName());
            }
            Path path = ((PathDataSource)this.ds).getPath();
            try {
                Files.delete(path);
                log.info("Download " + this.id + " file " + path + " deleted");
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Doanload " + this.id + " failed to delete file " + path, e);
            }
        } else {
            log.info("Download " + this.id + " removed. Data source remaining: " + this.ds);
        }
    }

    public Long getContentLength() {
        if (this.ds instanceof DateDataSource) {
            return ((DateDataSource)this.ds).getContentLength();
        }
        return null;
    }
}

