/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.download;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.inject.Singleton;
import org.aktin.broker.PathDataSource;
import org.aktin.broker.download.AbstractDownload;
import org.aktin.broker.download.DataSourceDownload;
import org.aktin.broker.download.Download;

@Singleton
public class DownloadManager {
    private static final Logger log = Logger.getLogger(DownloadManager.class.getName());
    private long expirationMillis = 600000L;
    private Hashtable<UUID, AbstractDownload> store = new Hashtable();
    private Path tempDir;

    public DownloadManager() {
    }

    public DownloadManager(Path tempDir) throws IOException {
        this();
        this.setTempDirectory(tempDir);
    }

    public void setTempDirectory(Path dir) throws IOException {
        this.tempDir = dir;
        Files.createDirectories(this.tempDir, new FileAttribute[0]);
    }

    public Download get(UUID id) throws IOException {
        this.cleanupExpired();
        return this.store.get(id);
    }

    public Download createDataSourceDownload(DataSource ds, String name) {
        DataSourceDownload download = new DataSourceDownload(ds);
        this.addDownload(download);
        if (name != null) {
            download.setName(name);
        }
        return download;
    }

    private void addDownload(AbstractDownload download) {
        download.expiration = System.currentTimeMillis() + this.expirationMillis;
        download.id = UUID.randomUUID();
        this.store.put(download.id, download);
        log.info("Download added with UUID " + download.id);
    }

    public Download createTemporaryFile(String mediaType, String name) throws IOException {
        Path temp = this.tempDir != null ? Files.createTempFile(this.tempDir, "download", null, new FileAttribute[0]) : Files.createTempFile("download", null, new FileAttribute[0]);
        PathDataSource ds = new PathDataSource(temp, mediaType, Instant.now());
        DataSourceDownload download = new DataSourceDownload(ds, true);
        download.setName(name);
        this.addDownload(download);
        return download;
    }

    public void cleanupExpired() throws IOException {
        Iterator<Map.Entry<UUID, AbstractDownload>> i = this.store.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (i.hasNext()) {
            AbstractDownload entry = i.next().getValue();
            if (entry.getExpireTimestamp() >= now) continue;
            log.info("Expired download " + entry.getId());
            i.remove();
            entry.postRemovalCleanup();
        }
    }
}

