/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.notify;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.aktin.broker.notify.SessionConfigurator;

@ServerEndpoint(value="/broker-notify", configurator=SessionConfigurator.class)
public class BrokerWebsocket {
    private static final Logger log = Logger.getLogger(BrokerWebsocket.class.getName());
    private static Set<Session> clients = Collections.synchronizedSet(new HashSet());

    @OnOpen
    public void open(Session session) {
        log.info("Session created: " + session.getId());
        clients.add(session);
        try {
            session.getBasicRemote().sendText("welcome " + session.getUserPrincipal());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to send welcome message", e);
        }
    }

    @OnClose
    public void close(Session session) {
        clients.remove(session);
        log.info("Session closed: " + session.getId());
    }

    @OnMessage
    public void message(Session session, String message) {
        log.info("Session message: " + session.getId() + ": " + message);
    }

    private static int broadcast(String message, boolean adminOnly) {
        if (clients.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (Session session : clients) {
            if (adminOnly) {
                // empty if block
            }
            if (!session.isOpen()) continue;
            session.getAsyncRemote().sendText(message);
            ++count;
        }
        return count;
    }

    public static void broadcastRequestPublished(int requestId) {
        BrokerWebsocket.broadcast("published " + requestId, false);
    }

    public static void broadcastRequestClosed(int requestId) {
        BrokerWebsocket.broadcast("closed " + requestId, false);
    }

    public static void broadcastRequestNodeStatus(int requestId, int nodeId, String status) {
        BrokerWebsocket.broadcast("status " + requestId + " " + nodeId + " " + status, true);
    }
}

