/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.aktin.broker.AbstractRequestEndpoint;
import org.aktin.broker.RequestTypeManager;
import org.aktin.broker.RequireAdmin;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.notify.BrokerWebsocket;
import org.aktin.broker.xml.RequestInfo;
import org.aktin.broker.xml.RequestList;
import org.aktin.broker.xml.RequestStatusList;
import org.aktin.broker.xml.RequestTargetNodes;

@Path(value="/broker/request")
public class RequestAdminEndpoint
extends AbstractRequestEndpoint {
    private static final Logger log = Logger.getLogger(RequestAdminEndpoint.class.getName());
    @Inject
    private BrokerBackend db;
    @Inject
    private RequestTypeManager typeManager;

    @POST
    @RequireAdmin
    public Response createRequest(Reader content, @Context HttpHeaders headers, @Context UriInfo info) throws URISyntaxException {
        MediaType type = headers.getMediaType();
        try {
            int id;
            if (type != null) {
                type = RequestAdminEndpoint.removeCharsetInfo(type);
                id = this.db.createRequest(type.toString(), content);
            } else {
                id = this.db.createRequest();
            }
            String ref = "/broker/request/" + Integer.toString(id);
            UriBuilder ub = info.getBaseUriBuilder().path(ref);
            String forceScheme = System.getProperty("force.uri.scheme");
            if (forceScheme != null) {
                log.info("Forcing response location URI scheme " + forceScheme);
                ub.scheme(forceScheme);
            }
            return Response.created((URI)ub.build(new Object[0])).build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to create request", e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="headers")
    @Produces(value={"text/plain"})
    public String debugReturnRequestHeaders(@Context HttpHeaders headers) {
        StringBuilder b = new StringBuilder();
        MultivaluedMap req = headers.getRequestHeaders();
        for (String key : req.keySet()) {
            b.append(key).append(": ");
            boolean multiple = false;
            for (String value : (List)req.get((Object)key)) {
                if (multiple) {
                    b.append(", ");
                }
                b.append(value);
                multiple = true;
            }
            b.append("\n");
        }
        return b.toString();
    }

    @PUT
    @Path(value="{id}")
    @RequireAdmin
    public Response createRequest(@PathParam(value="id") String requestId, Reader content, @Context HttpHeaders headers) throws URISyntaxException {
        MediaType type = headers.getMediaType();
        try {
            type = RequestAdminEndpoint.removeCharsetInfo(type);
            this.db.setRequestDefinition(Integer.parseInt(requestId), type.toString(), content);
            return Response.ok().build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to create request definition", e);
            return Response.serverError().build();
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "Unable to parse request id: " + requestId, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @RequireAdmin
    public Response listAllRequests() {
        try {
            return Response.ok((Object)new RequestList(this.db.listAllRequests())).build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to read requests", e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @RequireAdmin
    public Response deleteRequest(@PathParam(value="id") String id) {
        int i;
        try {
            i = Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            log.warning("Unable to delete non-numeric request id: " + id);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.db.deleteRequest(i);
            return Response.noContent().build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to delete request " + id, e);
            return Response.serverError().build();
        }
    }

    @RequireAdmin
    @GET
    @Path(value="{id}")
    public Response getRequest(@PathParam(value="id") Integer requestId, @Context HttpHeaders headers) throws SQLException, IOException, NotFoundException {
        List accept = headers.getAcceptableMediaTypes();
        return this.getRequest((int)requestId, accept);
    }

    @OPTIONS
    @Path(value="{id}")
    @RequireAdmin
    public Response getRequestInfo(@PathParam(value="id") int requestId, @Context HttpHeaders headers) throws SQLException, IOException {
        RequestInfo info = this.db.getRequestInfo(requestId);
        Response.ResponseBuilder response = info == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok((Object)info, (MediaType)MediaType.APPLICATION_XML_TYPE);
        return response.allow(new String[]{"GET", "PUT", "DELETE", "OPTIONS"}).build();
    }

    @GET
    @Path(value="{id}/status")
    @RequireAdmin
    @Produces(value={"application/xml"})
    public RequestStatusList getRequestInfo(@PathParam(value="id") Integer requestId) throws SQLException, IOException {
        List list = this.db.listRequestNodeStatus(requestId);
        if (list == null) {
            throw new NotFoundException();
        }
        return new RequestStatusList(list);
    }

    @GET
    @Path(value="{id}/nodes")
    @Produces(value={"application/xml"})
    @RequireAdmin
    public RequestTargetNodes getRequestTargetNodes(@PathParam(value="id") Integer requestId) throws SQLException, IOException, NotFoundException {
        int[] nodes = this.db.getRequestTargets(requestId);
        if (nodes == null) {
            throw new NotFoundException();
        }
        return new RequestTargetNodes(nodes);
    }

    @DELETE
    @Path(value="{id}/nodes")
    @RequireAdmin
    public void clearRequestTargetNodes(@PathParam(value="id") Integer requestId) throws SQLException, IOException, NotFoundException {
        int[] nodes = this.db.getRequestTargets(requestId);
        if (nodes == null) {
            throw new NotFoundException();
        }
        this.db.clearRequestTargets(requestId);
    }

    @PUT
    @Path(value="{id}/nodes")
    @Consumes(value={"application/xml"})
    @RequireAdmin
    public void setRequestTargetNodes(@PathParam(value="id") Integer requestId, RequestTargetNodes nodes) throws SQLException, IOException, NotFoundException {
        if (nodes == null || nodes.getNodes() == null || nodes.getNodes().length == 0) {
            String message = "node targeting requires at least one node";
            log.warning(message);
            throw new BadRequestException(message);
        }
        this.db.setRequestTargets(requestId, nodes.getNodes());
    }

    @GET
    @Path(value="{id}/status/{nodeId}")
    @RequireAdmin
    public Response getRequestNodeStatusMessage(@PathParam(value="id") Integer requestId, @PathParam(value="nodeId") Integer nodeId) throws SQLException, IOException {
        Reader r = this.db.getRequestNodeStatusMessage(requestId, nodeId);
        if (r == null) {
            throw new NotFoundException();
        }
        return Response.ok((Object)r, (String)"text/plain").build();
    }

    @POST
    @Path(value="{id}/publish")
    @RequireAdmin
    public void publishRequest(@PathParam(value="id") Integer requestId) throws SQLException {
        RequestInfo info = this.db.getRequestInfo(requestId);
        if (info == null) {
            throw new NotFoundException();
        }
        if (info.published == null) {
            this.db.setRequestPublished(requestId, Instant.now());
            BrokerWebsocket.broadcastRequestPublished(requestId);
        }
    }

    @POST
    @Path(value="{id}/close")
    @RequireAdmin
    public void closeRequest(@PathParam(value="id") Integer requestId) throws SQLException {
        RequestInfo info = this.db.getRequestInfo(requestId);
        if (info == null) {
            throw new NotFoundException();
        }
        if (info.closed == null) {
            this.db.setRequestClosed(requestId, Instant.now());
            BrokerWebsocket.broadcastRequestClosed(requestId);
        }
    }

    @Override
    protected RequestTypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    protected BrokerBackend getBroker() {
        return this.db;
    }
}

