/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.rest.RequireAdmin;

@RequireAdmin
@Provider
@Priority(value=2000)
public class AuthorizationRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(AuthorizationRequestFilter.class.getName());

    public void filter(ContainerRequestContext ctx) throws IOException {
        Principal user = (Principal)ctx.getSecurityContext().getUserPrincipal();
        if (user == null || !user.isAdmin()) {
            log.info("Authorization admin denied to " + user);
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            return;
        }
    }
}

