/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.ws.rs.core.MediaType;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.util.PathDataSource;
import org.aktin.broker.xml.ResultInfo;

@Singleton
public class AggregatorImpl
implements AggregatorBackend {
    private DataSource ds;
    private Path dataDir;

    public AggregatorImpl() throws IOException {
        this.setDataDirectory(Paths.get("aggregator-data", new String[0]));
    }

    public AggregatorImpl(DataSource ds, Path dataDir) throws IOException {
        this.setDataDirectory(dataDir);
        this.setBrokerDB(ds);
    }

    public void setDataDirectory(Path dataDir) throws IOException {
        this.dataDir = dataDir;
        Files.createDirectories(dataDir, new FileAttribute[0]);
    }

    @Override
    @Resource(name="brokerDB")
    public void setBrokerDB(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public void clearDataDirectory() throws IOException {
        try (Stream<Path> files = Files.list(this.dataDir);){
            files.forEach(t -> {
                try {
                    Files.delete(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    private void removeData(String data_file) throws IOException {
        Path file = this.dataDir.resolve(data_file);
        Files.delete(file);
    }

    private String getFileExtension(MediaType mediaType) {
        if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return ".xml";
        }
        if (mediaType.getType().equals("text")) {
            return ".txt";
        }
        return ".bin";
    }

    private String readData(int requestId, int nodeId, MediaType mediaType, InputStream content) throws IOException {
        String name = "result-" + requestId + "-" + nodeId + this.getFileExtension(mediaType);
        Path file = this.dataDir.resolve(name);
        Files.copy(content, file, new CopyOption[0]);
        return name;
    }

    public List<ResultInfo> listResults(int requestId) throws SQLException {
        ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
        try (Connection dbc = this.ds.getConnection();
             Statement st = dbc.createStatement();){
            ResultSet rs = st.executeQuery("SELECT node_id, media_type FROM request_node_results WHERE request_id=" + requestId);
            while (rs.next()) {
                list.add(new ResultInfo(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
        }
        return list;
    }

    public PathDataSource getResult(int requestId, int nodeId) throws SQLException {
        PathDataSource data;
        try (Connection dbc = this.ds.getConnection();
             Statement st = dbc.createStatement();){
            ResultSet rs = st.executeQuery("SELECT media_type, last_modified, data_file FROM request_node_results WHERE request_id=" + requestId + " AND node_id=" + nodeId);
            if (rs.next()) {
                Timestamp ts = rs.getTimestamp(2);
                data = new PathDataSource(this.dataDir.resolve(rs.getString(3)), rs.getString(1), ts.toInstant());
            } else {
                data = null;
            }
            rs.close();
        }
        return data;
    }

    @Override
    public void addOrReplaceResult(int requestId, int nodeId, MediaType mediaType, InputStream content) throws SQLException {
        try (Connection dbc = this.ds.getConnection();
             Statement st = dbc.createStatement();){
            String file;
            String insertOrUpdate;
            ResultSet rs = st.executeQuery("SELECT media_type, data_file FROM request_node_results WHERE request_id=" + requestId + " AND node_id=" + nodeId);
            if (rs.next()) {
                String prevType = rs.getString(1);
                Objects.requireNonNull(prevType);
                try {
                    this.removeData(rs.getString(2));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                insertOrUpdate = "UPDATE request_node_results SET media_type=?, data_file=?, last_modified=NOW() WHERE request_id=? AND node_id=?";
            } else {
                insertOrUpdate = "INSERT INTO request_node_results (media_type, data_file, request_id, node_id, first_received, last_modified) VALUES(?,?,?,?, NOW(), NOW())";
            }
            rs.close();
            try {
                file = this.readData(requestId, nodeId, mediaType, content);
                content.close();
            }
            catch (IOException e) {
                throw new SQLException("Unable to read supplied data", e);
            }
            try (PreparedStatement ps = dbc.prepareStatement(insertOrUpdate);){
                ps.setString(1, mediaType.toString());
                ps.setString(2, file);
                ps.setInt(3, requestId);
                ps.setInt(4, nodeId);
                ps.executeUpdate();
            }
            dbc.commit();
        }
    }

    public String[] getDistinctResultTypes(int requestId) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        try (Connection dbc = this.ds.getConnection();
             Statement st = dbc.createStatement();){
            ResultSet rs = st.executeQuery("SELECT DISTINCT media_type FROM request_node_results WHERE request_id=" + requestId);
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            rs.close();
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean isRequestWritable(int requestId, int nodeId) {
        return true;
    }
}

