/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.server.DateDataSource;
import org.aktin.broker.xml.RequestInfo;
import org.aktin.broker.xml.RequestStatusInfo;
import org.aktin.broker.xml.RequestStatusList;
import org.aktin.broker.xml.RequestTargetNodes;
import org.aktin.broker.xml.ResultInfo;

public class RequestBundleExport {
    private static final Logger log = Logger.getLogger(RequestBundleExport.class.getName());
    private BrokerBackend backend;
    private JAXBContext jaxb;
    private AggregatorBackend aggregator;
    private Charset charset;

    public RequestBundleExport(BrokerBackend backend) throws JAXBException {
        this.backend = backend;
        this.jaxb = JAXBContext.newInstance((Class[])new Class[]{RequestInfo.class, RequestStatusList.class, RequestTargetNodes.class});
        this.charset = Charset.forName("UTF-8");
    }

    private void configureMarshaller(Marshaller marshaller) {
        try {
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)this.charset.name());
        }
        catch (PropertyException e) {
            log.log(Level.WARNING, "Failed to configure JAXB marshaller for readability", e);
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller m = this.jaxb.createMarshaller();
        this.configureMarshaller(m);
        return m;
    }

    public void setAggregator(AggregatorBackend aggregator) {
        this.aggregator = aggregator;
    }

    private void writeStatusList(int requestId, ZipOutputStream zip) throws SQLException, JAXBException, IOException {
        List list = this.backend.listRequestNodeStatus(requestId);
        Objects.requireNonNull(list);
        ZipEntry entry = new ZipEntry("status.xml");
        zip.putNextEntry(entry);
        this.createMarshaller().marshal((Object)new RequestStatusList(list), (OutputStream)zip);
        zip.closeEntry();
        for (RequestStatusInfo status : list) {
            if (status.type == null) continue;
            Reader reader = this.backend.getRequestNodeStatusMessage(requestId, status.node);
            try {
                entry = new ZipEntry(status.node + "_info" + RequestBundleExport.guessFileExtension(status.type));
                zip.putNextEntry(entry);
                RequestBundleExport.transferReader(reader, zip, this.charset);
                zip.closeEntry();
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    private void writeAggregatorResults(int requestId, ZipOutputStream zip) throws SQLException, IOException {
        Objects.requireNonNull(this.aggregator);
        int numTypes = this.aggregator.getDistinctResultTypes(requestId).length;
        for (ResultInfo info : this.aggregator.listResults(requestId)) {
            String type = info.type;
            String ext = RequestBundleExport.guessFileExtension(type);
            String name = numTypes == 1 ? info.node + "_result" + ext : info.node + "_" + URLEncoder.encode(type, this.charset.name()) + ext;
            ZipEntry entry = new ZipEntry(name);
            DateDataSource dds = this.aggregator.getResult(requestId, info.node);
            entry.setTime(dds.getLastModified().toEpochMilli());
            zip.putNextEntry(entry);
            try (InputStream in = dds.getInputStream();){
                RequestBundleExport.transferInput(in, zip);
            }
            zip.closeEntry();
        }
    }

    public static String guessFileExtension(String mediaType) {
        String[] parts = mediaType.split(";");
        if (parts.length > 1) {
            mediaType = parts[0];
        }
        if (mediaType.endsWith("xml")) {
            return ".xml";
        }
        if (mediaType.endsWith("json")) {
            return ".json";
        }
        if (mediaType.startsWith("text")) {
            return ".txt";
        }
        if (mediaType.equals("application/zip")) {
            return ".zip";
        }
        return "";
    }

    private static void transferReader(Reader reader, OutputStream out, Charset charset) throws IOException {
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer cb = CharBuffer.allocate(1024);
        ByteBuffer bb = ByteBuffer.allocate(2048);
        while (reader.read(cb) != -1) {
            cb.flip();
            encoder.encode(cb, bb, false);
            cb.compact();
            bb.flip();
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
            bb.position(bb.position() + bb.remaining());
            bb.compact();
        }
        cb.flip();
        do {
            encoder.encode(cb, bb, true);
            bb.flip();
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
            bb.position(bb.position() + bb.remaining());
            bb.compact();
        } while (cb.hasRemaining());
        encoder.flush(bb);
        bb.flip();
        out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
    }

    private static void transferInput(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > -1) {
            out.write(buffer, 0, n);
        }
    }

    private void writeRequestDefinition(int requestId, String mediaType, OutputStream out) throws IOException, SQLException {
        try (Reader reader = this.backend.getRequestDefinition(requestId, mediaType);){
            RequestBundleExport.transferReader(reader, out, this.charset);
        }
    }

    private void writeRequestData(int requestId, ZipOutputStream zip) throws SQLException, IOException, JAXBException {
        RequestInfo info = this.backend.getRequestInfo(requestId);
        Marshaller m = this.createMarshaller();
        ZipEntry entry = new ZipEntry("request.xml");
        zip.putNextEntry(entry);
        m.marshal((Object)info, (OutputStream)zip);
        zip.closeEntry();
        if (info.types.length == 1) {
            String type = info.types[0];
            String ext = RequestBundleExport.guessFileExtension(type);
            entry = new ZipEntry("definition" + ext);
            zip.putNextEntry(entry);
            this.writeRequestDefinition(requestId, type, zip);
            zip.closeEntry();
        } else {
            for (int i = 0; i < info.types.length; ++i) {
                String type = info.types[i];
                String ext = RequestBundleExport.guessFileExtension(type);
                entry = new ZipEntry("definition_" + i + ext);
                zip.putNextEntry(entry);
                this.writeRequestDefinition(requestId, type, zip);
                zip.closeEntry();
            }
        }
    }

    public void createBundle(int requestId, OutputStream dest) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(dest);){
            out.setComment("Bundle for request " + requestId);
            this.writeStatusList(requestId, out);
            int[] nodes = this.backend.getRequestTargets(requestId);
            if (nodes != null) {
                ZipEntry entry = new ZipEntry("node-restriction.xml");
                out.putNextEntry(entry);
                this.createMarshaller().marshal((Object)new RequestTargetNodes(nodes), (OutputStream)out);
                out.closeEntry();
            }
            this.writeRequestData(requestId, out);
            if (this.aggregator != null) {
                this.writeAggregatorResults(requestId, out);
            }
        }
        catch (SQLException | JAXBException e) {
            throw new IOException(e);
        }
    }

    public void createBundle(int requestId, Path path) throws IOException {
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            this.createBundle(requestId, out);
        }
    }
}

