/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aktin.broker.server.DateDataSource;

public class PathDataSource
implements DateDataSource {
    private static final Logger log = Logger.getLogger(PathDataSource.class.getName());
    private Path path;
    private String type;
    private Instant lastModified;

    public PathDataSource(Path path, String type, Instant lastModified) {
        this.path = path;
        this.type = type;
        this.lastModified = lastModified;
    }

    public String getContentType() {
        return this.type;
    }

    public String toString() {
        return "PathDataSource(path=" + this.path.toString() + ", type=" + this.type + ")";
    }

    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public Long getContentLength() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to determine file size", e);
            return null;
        }
    }

    public Path getPath() {
        return this.path;
    }
}

