/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.websocket;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.HeaderAuthentication;

public class HeaderAuthSessionConfigurator
extends ServerEndpointConfig.Configurator {
    private static final Logger log = Logger.getLogger(HeaderAuthSessionConfigurator.class.getName());
    public static final String AUTH_USER = "auth-user";
    private HeaderAuthentication auth;
    private AuthCache cache;

    @Inject
    public HeaderAuthSessionConfigurator(HeaderAuthentication auth, AuthCache cache) {
        this.auth = auth;
        this.cache = cache;
    }

    private static final Function<String, String> mapSingleHeader(final Map<String, List<String>> headers) {
        return new Function<String, String>(){

            @Override
            public String apply(String name) {
                List h = (List)headers.get(name);
                if (h == null || h.size() == 0) {
                    return null;
                }
                return (String)h.get(0);
            }
        };
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        Objects.requireNonNull(this.auth, "CDI failed for HeaderAuthentication");
        Objects.requireNonNull(this.cache, "CDI failed for AuthCache");
        Principal user = null;
        try {
            AuthInfo info = this.auth.authenticateByHeaders(HeaderAuthSessionConfigurator.mapSingleHeader(request.getHeaders()));
            if (info != null) {
                user = this.cache.getPrincipal(info);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unexpected authentication failure", e);
        }
        super.modifyHandshake(sec, request, response);
        if (user != null) {
            log.info("Websocket handshake auth user: " + user.getName());
            sec.getUserProperties().put(AUTH_USER, user);
        } else {
            log.info("Websocket handshake auth unauthorized. Aborting handshake.");
            response.getHeaders().put("Sec-WebSocket-Accept", Collections.emptyList());
        }
    }
}

