/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.AuthRole;
import org.aktin.broker.xml.Node;

@Singleton
public class AuthCache
implements Flushable,
Closeable {
    private static final Logger log = Logger.getLogger(AuthCache.class.getName());
    private Map<String, Principal> cache = new HashMap<String, Principal>();
    private BrokerBackend backend;

    public AuthCache() {
    }

    @Inject
    public AuthCache(BrokerBackend backend) {
        this();
        this.setBackend(backend);
    }

    private void setBackend(BrokerBackend backend) {
        this.backend = backend;
    }

    private boolean isNodePrincipal(AuthInfo info) {
        return info.getRoles().contains(AuthRole.NODE_READ) || info.getRoles().contains(AuthRole.NODE_WRITE);
    }

    public Principal getPrincipal(AuthInfo info) throws IOException {
        Objects.requireNonNull(info);
        Objects.requireNonNull(info.getClientDN());
        Objects.requireNonNull(info.getUserId());
        Principal p = this.cache.get(info.getUserId());
        if (p == null) {
            if (this.isNodePrincipal(info)) {
                try {
                    p = this.backend.accessPrincipal(info);
                }
                catch (SQLException e) {
                    throw new IOException("SQL error during principal retrieval for node " + info.getUserId(), e);
                }
            } else {
                p = Principal.createAdminPrincipal(info);
            }
            this.cache.put(info.getUserId(), p);
        }
        p.updateLastAccessed();
        return p;
    }

    public void fillCachedAccessTimestamps(Iterable<Node> nodes) {
        HashMap<Integer, Principal> lookup = new HashMap<Integer, Principal>();
        for (Principal p : this.cache.values()) {
            if (!p.isNode()) continue;
            lookup.put(p.getNodeId(), p);
        }
        for (Node node : nodes) {
            Principal p = (Principal)lookup.get(node.id);
            if (p == null) continue;
            Long ts = p.getLastAccessed();
            if (ts != null) {
                node.lastContact = Instant.ofEpochMilli(ts);
            }
            node.websocket = p.getWebsocketCount() > 0;
        }
    }

    @Override
    @PreDestroy
    public void flush() throws IOException {
        log.info("flushing");
        HashMap<Integer, Long> timestamps = new HashMap<Integer, Long>();
        for (Principal p : this.cache.values()) {
            if (!p.isNode()) continue;
            timestamps.put(p.getNodeId(), p.getLastAccessed());
        }
        try {
            this.backend.updateNodeLastSeen(timestamps);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        log.info("performing close");
        this.flush();
    }
}

