/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.rest;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.util.RequestConverter;
import org.aktin.broker.util.RequestTypeManager;

public abstract class AbstractRequestEndpoint {
    protected abstract RequestTypeManager getTypeManager();

    protected abstract BrokerBackend getBroker();

    public static MediaType removeCharsetInfo(MediaType type) {
        return new MediaType(type.getType(), type.getSubtype());
    }

    protected Response getRequest(int requestId, List<MediaType> accept) throws SQLException, IOException, NotFoundException, NotAcceptableException {
        MediaType[] available = this.getTypeManager().createMediaTypes(this.getBroker().getRequestTypes(requestId));
        if (available.length == 0) {
            throw new NotFoundException();
        }
        RequestConverter rc = this.getTypeManager().buildConverterChain(accept, Arrays.asList(available));
        if (rc == null) {
            throw new NotAcceptableException();
        }
        Reader def = this.getBroker().getRequestDefinition(requestId, rc.getConsumedType());
        def = rc.transform(def);
        return Response.ok((Object)def, (MediaType)MediaType.valueOf((String)rc.getProducedType()).withCharset("UTF-8")).build();
    }
}

