/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.websocket;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.aktin.broker.auth.Principal;

public abstract class AbstractBroadcastWebsocket {
    private static final Logger log = Logger.getLogger(AbstractBroadcastWebsocket.class.getName());

    protected abstract boolean isAuthorized(Principal var1);

    protected abstract void addSession(Session var1, Principal var2);

    protected abstract void removeSession(Session var1, Principal var2);

    @OnOpen
    public void open(Session session) {
        Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
        log.log(Level.INFO, "Websocket session {0} created for user {1}", new Object[]{session.getId(), user});
        if (this.isAuthorized(user)) {
            this.addSession(session, user);
        } else {
            try {
                session.close();
                return;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close session", e);
            }
        }
        try {
            session.getBasicRemote().sendText("welcome " + user.getName());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to send welcome message", e);
        }
    }

    @OnClose
    public void close(Session session) {
        Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
        this.removeSession(session, user);
        log.log(Level.INFO, "Websocket session {0} closed for user {1} ", new Object[]{session.getId(), user});
    }

    @OnMessage
    public void message(Session session, String message) {
        Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
        if (message.startsWith("ping ")) {
            try {
                session.getBasicRemote().sendText("pong " + message.substring(5));
                log.log(Level.INFO, "Websocket ping reply sent for session {0} user {1}", new Object[]{session.getId(), user});
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Websocket ping pong reply failed for user " + user, e);
            }
        } else {
            log.log(Level.INFO, "Ignoring message from user {0}", user);
        }
    }

    @OnMessage
    public void message(Session session, PongMessage message) {
        Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
        log.log(Level.INFO, "Websocket pong message for session {0} user {1} length {2}", new Object[]{session.getId(), user, message.getApplicationData().remaining()});
    }

    @OnError
    public void error(Session session, Throwable t) {
        Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
        log.log(Level.INFO, "Websocket session {0} error for user {1}: {2}", new Object[]{session.getId(), user, t});
    }

    static int broadcast(Set<Session> clients, String message) {
        return AbstractBroadcastWebsocket.broadcast(clients, message, p -> true);
    }

    static int broadcast(Set<Session> clients, String message, Predicate<Principal> principalFilter) {
        Objects.requireNonNull(principalFilter);
        if (clients.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (Session session : clients) {
            Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
            if (user == null) {
                log.log(Level.WARNING, "Skipping websocket session {0} without authentication", session.getId());
                continue;
            }
            if (!principalFilter.test(user) || !session.isOpen()) continue;
            session.getAsyncRemote().sendText(message);
            ++count;
        }
        return count;
    }

    protected static Principal getSessionPrincipal(Session session) {
        return (Principal)session.getUserProperties().get("auth-user");
    }
}

