/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.websocket;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.websocket.AbstractBroadcastWebsocket;
import org.aktin.broker.websocket.HeaderAuthSessionConfigurator;

@ServerEndpoint(value="/broker/websocket", configurator=HeaderAuthSessionConfigurator.class)
public class RequestAdminWebsocket
extends AbstractBroadcastWebsocket {
    public static final String REST_PATH = "/broker/websocket";
    private static Set<Session> clients = Collections.synchronizedSet(new HashSet());
    private static final Logger log = Logger.getLogger(RequestAdminWebsocket.class.getName());

    public static void broadcastRequestCreated(int requestId) {
        RequestAdminWebsocket.broadcast(clients, "created " + requestId);
    }

    public static void broadcastRequestPublished(int requestId) {
        RequestAdminWebsocket.broadcast(clients, "published " + requestId);
    }

    public static void broadcastRequestClosed(int requestId) {
        RequestAdminWebsocket.broadcast(clients, "closed " + requestId);
    }

    public static void broadcastRequestNodeStatus(int requestId, int nodeId, String status) {
        RequestAdminWebsocket.broadcast(clients, "status " + requestId + " " + nodeId + " " + status);
    }

    public static void broadcastNodeResourceChange(int nodeId, String resourceId) {
        RequestAdminWebsocket.broadcast(clients, "resource " + nodeId + " " + resourceId);
    }

    public static void broadcastNodeResult(int requestId, int nodeId, String mediaType) {
        RequestAdminWebsocket.broadcast(clients, "result " + requestId + " " + nodeId + " " + mediaType);
    }

    @Override
    protected boolean isAuthorized(Principal principal) {
        if (!principal.isAdmin()) {
            log.log(Level.INFO, "Non admin client rejected for request admin websocket: {}", principal.getName());
            return false;
        }
        return true;
    }

    @Override
    protected void addSession(Session session, Principal user) {
        user.incrementWebsocketCount();
        clients.add(session);
    }

    @Override
    protected void removeSession(Session session, Principal user) {
        user.decrementWebsocketCount();
        clients.remove(session);
    }
}

