/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.aktin.broker.auth.CascadedHeaderAuthentication;
import org.aktin.broker.server.auth.AbstractAuthProvider;
import org.aktin.broker.server.auth.AuthProvider;
import org.aktin.broker.server.auth.HeaderAuthentication;

public class CascadedAuthProvider
extends AbstractAuthProvider {
    private List<AuthProvider> providers;

    public CascadedAuthProvider(List<AuthProvider> providers) {
        this.providers = providers;
    }

    public void setBasePath(Path path) {
        this.providers.forEach(p -> p.setBasePath(path));
    }

    public HeaderAuthentication getInstance() throws IOException {
        HeaderAuthentication[] inst = new HeaderAuthentication[this.providers.size()];
        for (int i = 0; i < this.providers.size(); ++i) {
            inst[i] = this.providers.get(i).getInstance();
        }
        return new CascadedHeaderAuthentication(inst);
    }

    public void bindSingletons(BiConsumer<Object, Class<?>> binder) {
        for (AuthProvider delegate : this.providers) {
            delegate.bindSingletons(binder);
        }
    }

    public Class<?>[] getEndpoints() {
        ArrayList endpoints = new ArrayList();
        this.providers.forEach(p -> endpoints.addAll(Arrays.asList(p.getEndpoints())));
        return endpoints.toArray(new Class[endpoints.size()]);
    }
}

