/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.ws.rs.core.MediaType;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.db.DigestCalculatingInputStream;
import org.aktin.broker.server.Broker;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.util.DigestPathDataSource;
import org.aktin.broker.xml.Node;
import org.aktin.broker.xml.RequestInfo;
import org.aktin.broker.xml.RequestStatus;
import org.aktin.broker.xml.RequestStatusInfo;
import org.aktin.broker.xml.util.Util;

@Singleton
public class BrokerImpl
implements BrokerBackend,
Broker {
    private static final Logger log = Logger.getLogger(BrokerImpl.class.getName());
    private static final String[] RESOURCE_DIGESTS = new String[]{"MD5", "SHA-256"};
    private DataSource brokerDB;
    private Path dataDir;
    private int inMemoryTreshold = 0x100000;
    private static final String SELECT_MEDIATYPE_BY_REQUESTID = "SELECT media_type FROM request_definitions WHERE request_id=?";
    private Dbms dbms;

    public BrokerImpl() {
    }

    public BrokerImpl(DataSource brokerDB, Path dataDirectory) throws IOException {
        this();
        this.setBrokerDB(brokerDB);
        this.setDataDirectory(dataDirectory);
        Files.createDirectories(dataDirectory, new FileAttribute[0]);
    }

    @Override
    @Resource(name="brokerDB")
    public void setBrokerDB(DataSource brokerDB) {
        this.brokerDB = brokerDB;
        String pkg = brokerDB.getClass().getPackageName();
        this.dbms = pkg.startsWith("org.postgresql") ? Dbms.POSTGRES : Dbms.HSQL;
        log.info("Using DBMS dialect for " + String.valueOf((Object)this.dbms));
    }

    public void setDataDirectory(Path dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public void clearDataDirectory() throws IOException {
        try (Stream<Path> files = Files.list(this.dataDir);){
            files.forEach(t -> {
                try {
                    Files.delete(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public List<Node> getAllNodes() throws SQLException {
        ArrayList<Node> nl = new ArrayList<Node>();
        try (Connection dbc = this.brokerDB.getConnection();
             PreparedStatement st = dbc.prepareStatement("SELECT id, subject_dn, last_contact FROM nodes");){
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                nl.add(new Node(rs.getInt(1), rs.getString(2), rs.getTimestamp(3).toInstant()));
            }
            rs.close();
        }
        return nl;
    }

    public Node getNode(int nodeId) throws SQLException {
        Node n;
        block20: {
            try (Connection dbc = this.brokerDB.getConnection();){
                ResultSet rs;
                try (Statement st = dbc.createStatement();){
                    rs = st.executeQuery("SELECT id, subject_dn, last_contact FROM nodes WHERE id=" + nodeId);
                    n = rs.next() ? new Node(rs.getInt(1), rs.getString(2), rs.getTimestamp(3).toInstant()) : null;
                    rs.close();
                }
                if (n == null) break block20;
                st = dbc.createStatement();
                try {
                    rs = st.executeQuery("SELECT module, version FROM node_modules WHERE node_id=" + nodeId);
                    n.modules = new HashMap();
                    while (rs.next()) {
                        n.modules.put(rs.getString(1), rs.getString(2));
                    }
                    rs.close();
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
        }
        return n;
    }

    protected int getLastInsertId(Connection dbc) throws SQLException {
        String sql = this.dbms == Dbms.POSTGRES ? "SELECT LASTVAL()" : "CALL IDENTITY()";
        try (Statement st = dbc.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        throw new SQLException("Unable get last insert id");
    }

    private int createEmptyRequest(Connection dbc) throws SQLException {
        BrokerImpl.executeUpdate(dbc, "INSERT INTO requests(created) VALUES(NOW())");
        return this.getLastInsertId(dbc);
    }

    public int createRequest(String mediaType, Reader content) throws SQLException {
        int id;
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            id = this.createEmptyRequest(dbc);
            this.setRequestDefinition(dbc, id, mediaType, content);
            dbc.commit();
        }
        return id;
    }

    public int createRequest() throws SQLException {
        int id;
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            id = this.createEmptyRequest(dbc);
            dbc.commit();
        }
        return id;
    }

    private static String readAllContent(Reader reader) throws IOException {
        int numChars;
        char[] buffer = new char[4096];
        StringBuilder builder = new StringBuilder();
        while ((numChars = reader.read(buffer)) >= 0) {
            builder.append(buffer, 0, numChars);
        }
        return builder.toString();
    }

    private void setClob(PreparedStatement ps, int index, Reader content) throws SQLException {
        if (this.dbms == Dbms.POSTGRES) {
            try {
                ps.setString(index, BrokerImpl.readAllContent(content));
            }
            catch (IOException e) {
                throw new SQLException("Unable to read from content stream", e);
            }
        } else {
            ps.setClob(index, content);
        }
    }

    private void setRequestDefinition(Connection dbc, int requestId, String mediaType, Reader content) throws SQLException {
        boolean hasRecord;
        try (PreparedStatement ps = dbc.prepareStatement("SELECT COUNT(*) FROM request_definitions WHERE request_id=? AND media_type=?");){
            ps.setInt(1, requestId);
            ps.setString(2, mediaType);
            ResultSet rs = ps.executeQuery();
            rs.next();
            hasRecord = rs.getInt(1) != 0;
            rs.close();
        }
        if (hasRecord) {
            ps = dbc.prepareStatement("UPDATE request_definitions SET query_def=? WHERE request_id=? AND media_type=?");
            try {
                this.setClob(ps, 1, content);
                ps.setInt(2, requestId);
                ps.setString(3, mediaType);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            log.info("Updated definition for request " + requestId + ": " + mediaType);
        } else {
            ps = dbc.prepareStatement("INSERT INTO request_definitions (request_id, media_type, query_def) VALUES(?,?,?)");
            try {
                ps.setInt(1, requestId);
                ps.setString(2, mediaType);
                this.setClob(ps, 3, content);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            log.info("New definition for request " + requestId + ": " + mediaType);
        }
    }

    public void setRequestDefinition(int requestId, String mediaType, Reader content) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            this.setRequestDefinition(dbc, requestId, mediaType, content);
            dbc.commit();
        }
    }

    public void deleteRequest(int id) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            BrokerImpl.executeUpdate(dbc, "DELETE FROM request_definitions WHERE request_id=" + id);
            BrokerImpl.executeUpdate(dbc, "DELETE FROM requests WHERE id=" + id);
            dbc.commit();
        }
        log.info("Request " + id + " deleted");
    }

    private List<RequestInfo> loadRequestList(ResultSet rs, int mediaTypeIndex, RequestInfoLoader loader) throws SQLException {
        ArrayList<RequestInfo> l = new ArrayList<RequestInfo>();
        ArrayList<String> types = new ArrayList<String>();
        int prevId = -1;
        RequestInfo req = null;
        while (rs.next()) {
            int id = rs.getInt(1);
            if (id != prevId) {
                if (req != null) {
                    req.setTypes(types.toArray(new String[types.size()]));
                    l.add(req);
                    types.clear();
                }
                req = loader.load(rs);
                types.add(rs.getString(mediaTypeIndex));
            } else {
                types.add(rs.getString(mediaTypeIndex));
            }
            prevId = id;
        }
        if (req != null) {
            req.setTypes(types.toArray(new String[types.size()]));
            l.add(req);
        }
        return l;
    }

    public List<RequestInfo> listAllRequests() throws SQLException {
        List<RequestInfo> list;
        try (Connection dbc = this.brokerDB.getConnection();
             Statement st = dbc.createStatement();){
            ResultSet rs = st.executeQuery("SELECT r.id, r.published, r.closed, d.media_type, r.targeted FROM requests r JOIN request_definitions d ON r.id=d.request_id ORDER BY r.id");
            list = this.loadRequestList(rs, 4, r -> new RequestInfo(r.getInt(1), this.optionalTimestamp(rs, 2), this.optionalTimestamp(rs, 3), rs.getBoolean(5)));
            rs.close();
        }
        return list;
    }

    private Instant optionalTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp ts = rs.getTimestamp(index);
        return ts == null ? null : ts.toInstant();
    }

    public List<String> getRequestTypes(int requestId) throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        try (Connection dbc = this.brokerDB.getConnection();
             PreparedStatement ps = dbc.prepareStatement(SELECT_MEDIATYPE_BY_REQUESTID);){
            ps.setInt(1, requestId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                types.add(rs.getString(1));
            }
        }
        return types;
    }

    private Reader createTemporaryClobReader(ResultSet rs, int index) throws SQLException, IOException {
        if (this.dbms == Dbms.POSTGRES) {
            return new StringReader(rs.getString(index));
        }
        Clob clob = rs.getClob(index);
        if (clob == null) {
            return null;
        }
        if (clob.length() < (long)this.inMemoryTreshold) {
            String str = null;
            try (Reader reader = clob.getCharacterStream();){
                str = Util.readContent((Reader)reader);
            }
            return new StringReader(str);
        }
        throw new UnsupportedOperationException("Temporary file CLOB reader not implemented yet. Size > " + this.inMemoryTreshold);
    }

    public Reader getRequestDefinition(int requestId, String mediaType) throws SQLException, IOException {
        try (Connection dbc = this.brokerDB.getConnection();){
            Reader reader;
            block16: {
                ResultSet rs;
                PreparedStatement ps;
                block14: {
                    Reader reader2;
                    block15: {
                        ps = dbc.prepareStatement("SELECT query_def FROM request_definitions WHERE request_id=? AND media_type=?");
                        try {
                            ps.setInt(1, requestId);
                            ps.setString(2, mediaType);
                            rs = ps.executeQuery();
                            if (rs.next()) break block14;
                            reader2 = null;
                            if (ps == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (ps != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ps.close();
                    }
                    return reader2;
                }
                reader = this.createTemporaryClobReader(rs, 1);
                if (ps == null) break block16;
                ps.close();
            }
            return reader;
        }
    }

    public List<RequestInfo> listRequestsForNode(int nodeId) throws SQLException {
        ArrayList<RequestInfo> list = new ArrayList<RequestInfo>();
        ArrayList<String> types = new ArrayList<String>();
        try (Connection dbc = this.brokerDB.getConnection();
             PreparedStatement ps = dbc.prepareStatement(SELECT_MEDIATYPE_BY_REQUESTID);
             Statement st = dbc.createStatement();){
            ResultSet rs = st.executeQuery("SELECT r.id, r.published, r.closed, r.targeted, s.retrieved, s.interaction, s.queued, s.processing, s.completed, s.rejected, s.failed FROM requests r LEFT OUTER JOIN request_node_status s ON r.id=s.request_id AND s.node_id=" + nodeId + " WHERE s.deleted IS NULL AND r.closed IS NULL AND r.published IS NOT NULL AND (r.targeted = FALSE OR s.request_id IS NOT NULL) ORDER BY r.id");
            while (rs.next()) {
                RequestInfo ri = new RequestInfo(rs.getInt(1), this.optionalTimestamp(rs, 2), this.optionalTimestamp(rs, 3), rs.getBoolean(4));
                RequestStatusInfo status = new RequestStatusInfo();
                status.retrieved = this.optionalTimestamp(rs, 5);
                status.interaction = this.optionalTimestamp(rs, 6);
                status.queued = this.optionalTimestamp(rs, 7);
                status.processing = this.optionalTimestamp(rs, 8);
                status.completed = this.optionalTimestamp(rs, 9);
                status.rejected = this.optionalTimestamp(rs, 10);
                status.failed = this.optionalTimestamp(rs, 11);
                ri.nodeStatus = status.getStatus() == null ? Collections.emptyList() : Collections.singletonList(status);
                list.add(ri);
                ps.setInt(1, rs.getInt(1));
                ps.clearWarnings();
                types.clear();
                ResultSet rs2 = ps.executeQuery();
                while (rs2.next()) {
                    types.add(rs2.getString(1));
                }
                if (types.isEmpty()) continue;
                ri.setTypes(types.toArray(new String[types.size()]));
            }
            rs.close();
        }
        return list;
    }

    public RequestInfo getRequestInfo(int requestId) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            RequestInfo requestInfo = this.loadRequest(dbc, requestId, true);
            return requestInfo;
        }
    }

    private RequestInfo loadRequest(Connection dbc, int requestId, boolean fillTypes) throws SQLException {
        RequestInfo ri = null;
        try (Statement st = dbc.createStatement();){
            ResultSet rs = st.executeQuery("SELECT r.id, r.published, r.closed, r.targeted FROM requests r WHERE r.id=" + requestId);
            if (rs.next()) {
                ri = new RequestInfo(rs.getInt(1), this.optionalTimestamp(rs, 2), this.optionalTimestamp(rs, 3), rs.getBoolean(4));
            }
            rs.close();
        }
        if (ri != null && fillTypes) {
            try (PreparedStatement ps = dbc.prepareStatement(SELECT_MEDIATYPE_BY_REQUESTID);){
                ps.setInt(1, requestId);
                ArrayList<String> types = new ArrayList<String>();
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    types.add(rs.getString(1));
                }
                if (!types.isEmpty()) {
                    ri.setTypes(types.toArray(new String[types.size()]));
                }
            }
        }
        return ri;
    }

    private boolean loadRequestNodeStatus(Connection dbc, int nodeId, int requestId, RequestStatusInfo ri) throws SQLException {
        boolean status_found = false;
        try (Statement st = dbc.createStatement();){
            ResultSet rs = st.executeQuery("SELECT retrieved, deleted FROM request_node_status r WHERE request_id=" + requestId + " AND node_id=" + nodeId);
            if (rs.next()) {
                status_found = true;
                ri.retrieved = this.optionalTimestamp(rs, 1);
                ri.deleted = this.optionalTimestamp(rs, 2);
            }
            rs.close();
        }
        return status_found;
    }

    public void setRequestNodeStatus(int requestId, int nodeId, RequestStatus status, Instant timestamp) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            Timestamp ts = Timestamp.from(timestamp);
            int rowCount = 0;
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE request_node_status SET ").append(status.name()).append("=?");
            if (status != RequestStatus.interaction) {
                sql.append(", interaction=NULL");
            }
            sql.append(" WHERE request_id=? AND node_id=?");
            try (PreparedStatement ps = dbc.prepareStatement(sql.toString());){
                ps.setTimestamp(1, ts);
                ps.setInt(2, requestId);
                ps.setInt(3, nodeId);
                rowCount = ps.executeUpdate();
            }
            if (rowCount == 0) {
                ps = dbc.prepareStatement("INSERT INTO request_node_status(request_id, node_id, " + status.name() + ") VALUES(?,?,?)");
                try {
                    ps.setInt(1, requestId);
                    ps.setInt(2, nodeId);
                    ps.setTimestamp(3, ts);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            dbc.commit();
        }
    }

    public void setRequestNodeStatusMessage(int requestId, int nodeId, String mediaType, Reader message) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();
             PreparedStatement ps = dbc.prepareStatement("UPDATE request_node_status SET message_type=?, message=? WHERE request_id=? AND node_id=?");){
            dbc.setAutoCommit(false);
            ps.setString(1, mediaType);
            this.setClob(ps, 2, message);
            ps.setInt(3, requestId);
            ps.setInt(4, nodeId);
            ps.executeUpdate();
            dbc.commit();
        }
    }

    public Reader getRequestNodeStatusMessage(int requestId, int nodeId) throws SQLException, IOException {
        try (Connection dbc = this.brokerDB.getConnection();){
            Reader reader;
            block16: {
                ResultSet rs;
                PreparedStatement ps;
                block14: {
                    Reader reader2;
                    block15: {
                        ps = dbc.prepareStatement("SELECT message_type, message FROM request_node_status WHERE request_id=? AND node_id=?");
                        try {
                            dbc.setReadOnly(true);
                            ps.setInt(1, requestId);
                            ps.setInt(2, nodeId);
                            rs = ps.executeQuery();
                            if (rs.next()) break block14;
                            reader2 = null;
                            if (ps == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (ps != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ps.close();
                    }
                    return reader2;
                }
                reader = this.createTemporaryClobReader(rs, 2);
                if (ps == null) break block16;
                ps.close();
            }
            return reader;
        }
    }

    public boolean markRequestDeletedForNode(int nodeId, int requestId) throws SQLException {
        boolean delete_ok;
        block20: {
            delete_ok = false;
            try (Connection dbc = this.brokerDB.getConnection();){
                dbc.setAutoCommit(false);
                RequestStatusInfo si = new RequestStatusInfo();
                RequestInfo ri = this.loadRequest(dbc, requestId, false);
                if (ri == null) {
                    break block20;
                }
                if (!this.loadRequestNodeStatus(dbc, nodeId, requestId, si)) {
                    try (Statement st = dbc.createStatement();){
                        st.executeUpdate("INSERT INTO request_node_status(deleted, node_id, request_id) VALUES(NOW()," + nodeId + "," + requestId + ")");
                    }
                    dbc.commit();
                    delete_ok = true;
                    break block20;
                }
                if (si.deleted != null) break block20;
                try (Statement st = dbc.createStatement();){
                    st.executeUpdate("UPDATE request_node_status SET deleted=NOW() WHERE request_id=" + requestId + " AND node_id=" + nodeId);
                }
                dbc.commit();
                delete_ok = true;
            }
        }
        return delete_ok;
    }

    public List<RequestStatusInfo> listRequestNodeStatus(Integer requestId) throws SQLException {
        ArrayList<RequestStatusInfo> list = new ArrayList<RequestStatusInfo>();
        try (Connection dbc = this.brokerDB.getConnection();
             Statement st = dbc.createStatement();){
            dbc.setReadOnly(true);
            ResultSet rs = st.executeQuery("SELECT node_id, retrieved, deleted, queued, processing, completed, rejected, failed, interaction, message_type  FROM request_node_status WHERE request_id=" + requestId);
            while (rs.next()) {
                RequestStatusInfo info = new RequestStatusInfo(rs.getInt(1));
                info.retrieved = this.optionalTimestamp(rs, 2);
                info.deleted = this.optionalTimestamp(rs, 3);
                info.queued = this.optionalTimestamp(rs, 4);
                info.processing = this.optionalTimestamp(rs, 5);
                info.completed = this.optionalTimestamp(rs, 6);
                info.rejected = this.optionalTimestamp(rs, 7);
                info.failed = this.optionalTimestamp(rs, 8);
                info.interaction = this.optionalTimestamp(rs, 9);
                info.type = rs.getString(10);
                list.add(info);
            }
            rs.close();
        }
        return list;
    }

    private DatabasePrincipal loadPrincipalByNodeKey(PreparedStatement ps, AuthInfo auth) throws SQLException {
        ps.setString(1, auth.getUserId());
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                DatabasePrincipal databasePrincipal = new DatabasePrincipal(rs.getInt(1), auth, rs.getString(2));
                return databasePrincipal;
            }
        }
        return null;
    }

    @Override
    public Principal accessPrincipal(AuthInfo auth) throws SQLException {
        DatabasePrincipal p;
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            PreparedStatement select_node = dbc.prepareStatement("SELECT id, subject_dn FROM nodes WHERE client_key=?");
            p = this.loadPrincipalByNodeKey(select_node, auth);
            if (p == null) {
                try (PreparedStatement ps = dbc.prepareStatement("INSERT INTO nodes(client_key, subject_dn, last_contact)VALUES(?,?,NOW())");){
                    ps.setString(1, auth.getUserId());
                    ps.setString(2, auth.getClientDN());
                    ps.executeUpdate();
                }
                log.log(Level.INFO, "First encounter with node, adding to database: {0}", auth.getUserId());
                select_node.clearParameters();
                p = this.loadPrincipalByNodeKey(select_node, auth);
            } else {
                BrokerImpl.executeUpdate(dbc, "UPDATE nodes SET last_contact=NOW() WHERE id=" + p.getNodeId());
                if (!Objects.equals(auth.getClientDN(), p.getDbSubjectDn())) {
                    log.log(Level.INFO, "Updating changed DN for node {0}: {1} -> {2}", new Object[]{p.getNodeId(), p.getDbSubjectDn(), auth.getClientDN()});
                    try (PreparedStatement ps = dbc.prepareStatement("UPDATE nodes SET subject_dn=? WHERE id=?");){
                        ps.setString(1, auth.getClientDN());
                        ps.setInt(2, p.getNodeId());
                        ps.executeUpdate();
                        p.setDbSubjectDn(auth.getClientDN());
                    }
                    catch (SQLException e) {
                        log.log(Level.WARNING, "Update of node DN failed", e);
                    }
                }
            }
            select_node.close();
            dbc.commit();
        }
        return p;
    }

    private static void executeUpdate(Connection dbc, String sql) throws SQLException {
        try (Statement st = dbc.createStatement();){
            st.executeUpdate(sql);
        }
    }

    private void updateRequestTimestamp(Connection dbc, int requestId, String timestampColumn, Instant value) throws SQLException {
        try (PreparedStatement ps = dbc.prepareStatement("UPDATE requests SET " + timestampColumn + "=? WHERE id=?");){
            if (value != null) {
                ps.setTimestamp(1, Timestamp.from(value));
            } else {
                ps.setTimestamp(1, null);
            }
            ps.setInt(2, requestId);
            ps.executeUpdate();
        }
    }

    public void setRequestPublished(int requestId, Instant timestamp) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(true);
            this.updateRequestTimestamp(dbc, requestId, "published", timestamp);
        }
    }

    public void setRequestClosed(int requestId, Instant timestamp) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(true);
            this.updateRequestTimestamp(dbc, requestId, "closed", timestamp);
        }
    }

    @Override
    public void updateNodeLastSeen(int[] nodeIds, long[] timestamps) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();
             PreparedStatement ps = dbc.prepareStatement("UPDATE nodes SET last_contact=? WHERE id=?");){
            dbc.setAutoCommit(true);
            for (int i = 0; i < nodeIds.length; ++i) {
                ps.setInt(1, nodeIds[i]);
                ps.setTimestamp(2, new Timestamp(timestamps[i]));
                ps.executeUpdate();
            }
        }
    }

    public void setRequestTargets(int requestId, int[] nodes) throws SQLException {
        Objects.requireNonNull(nodes);
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            BrokerImpl.executeUpdate(dbc, "UPDATE requests SET targeted=TRUE WHERE id=" + requestId);
            BrokerImpl.executeUpdate(dbc, "DELETE FROM request_node_status WHERE request_id=" + requestId);
            try (PreparedStatement ps = dbc.prepareStatement("INSERT INTO request_node_status(request_id,node_id)VALUES(?,?)");){
                ps.setInt(1, requestId);
                for (int i = 0; i < nodes.length; ++i) {
                    ps.setInt(2, nodes[i]);
                    ps.executeUpdate();
                }
            }
            dbc.commit();
        }
    }

    public int[] getRequestTargets(int requestId) throws SQLException {
        int[] nodes;
        block22: {
            nodes = null;
            try (Connection dbc = this.brokerDB.getConnection();){
                dbc.setReadOnly(true);
                boolean isTargeted = false;
                try (Statement st = dbc.createStatement();){
                    ResultSet rs = st.executeQuery("SELECT targeted FROM requests WHERE id=" + requestId);
                    if (rs.next()) {
                        isTargeted = rs.getBoolean(1);
                    }
                }
                if (!isTargeted) break block22;
                ArrayList<Integer> list = new ArrayList<Integer>();
                try (Statement st = dbc.createStatement();){
                    ResultSet rs = st.executeQuery("SELECT node_id FROM request_node_status WHERE request_id=" + requestId);
                    while (rs.next()) {
                        list.add(rs.getInt(1));
                    }
                    rs.close();
                }
                nodes = new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    nodes[i] = (Integer)list.get(i);
                }
            }
        }
        return nodes;
    }

    public void clearRequestTargets(int requestId) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(true);
            BrokerImpl.executeUpdate(dbc, "UPDATE requests SET targeted=FALSE WHERE id=" + requestId);
        }
    }

    private String nodeResourceName(int nodeId, String resourceId, MediaType mediaType) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(nodeId).append('_').append(URLEncoder.encode(resourceId, "UTF-8"));
            if (mediaType.isCompatible(MediaType.TEXT_PLAIN_TYPE)) {
                builder.append(".txt");
            } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) || mediaType.getSubtype().endsWith("+xml")) {
                builder.append(".xml");
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[][] replaceResourceFile(InputStream data, String oldFile, String newFile) throws IOException {
        DigestCalculatingInputStream di;
        if (oldFile != null) {
            try {
                Files.delete(this.dataDir.resolve(oldFile));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Unable to delete node resource: " + oldFile, e);
            }
        }
        try {
            di = new DigestCalculatingInputStream(data, RESOURCE_DIGESTS);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("message digest SHA-256 not available");
        }
        Files.copy(di, this.dataDir.resolve(newFile), new CopyOption[0]);
        return di.getDigests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeResource(int nodeId, String resourceId, MediaType mediaType, InputStream content) throws IOException, SQLException {
        String oldFile = null;
        String newFile = this.nodeResourceName(nodeId, resourceId, mediaType);
        try (Connection dbc = this.brokerDB.getConnection();){
            dbc.setAutoCommit(false);
            try (PreparedStatement ps = dbc.prepareStatement("SELECT data_file FROM node_resources WHERE node_id=? AND name=?");){
                ps.setInt(1, nodeId);
                ps.setString(2, resourceId);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    oldFile = rs.getString(1);
                }
            }
            byte[][] digests = this.replaceResourceFile(content, oldFile, newFile);
            try (PreparedStatement ps = null;){
                ps = oldFile != null ? dbc.prepareStatement("UPDATE node_resources SET media_type=?, last_modified=?, data_file=?, data_md5=?, data_sha2=? WHERE node_id=? AND name=?") : dbc.prepareStatement("INSERT INTO node_resources(media_type, last_modified, data_file, data_md5, data_sha2, node_id, name)VALUES(?,?,?,?,?,?,?)");
                ps.setString(1, mediaType.toString());
                ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                ps.setString(3, newFile);
                ps.setBytes(4, digests[0]);
                ps.setBytes(5, digests[1]);
                ps.setInt(6, nodeId);
                ps.setString(7, resourceId);
                ps.executeUpdate();
            }
            dbc.commit();
        }
    }

    public DigestPathDataSource getNodeResource(int nodeId, String resourceId) throws SQLException {
        byte[] sha2;
        byte[] md5;
        Path file;
        Instant lastModified;
        String mediaType;
        try (Connection dbc = this.brokerDB.getConnection();
             PreparedStatement ps = dbc.prepareStatement("SELECT media_type, last_modified, data_file, data_md5, data_sha2 FROM node_resources WHERE node_id=? AND name=?");){
            dbc.setReadOnly(true);
            ps.setInt(1, nodeId);
            ps.setString(2, resourceId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                DigestPathDataSource digestPathDataSource = null;
                return digestPathDataSource;
            }
            mediaType = rs.getString(1);
            lastModified = rs.getTimestamp(2).toInstant();
            file = this.dataDir.resolve(rs.getString(3));
            md5 = rs.getBytes(4);
            sha2 = rs.getBytes(5);
            rs.close();
        }
        DigestPathDataSource ds = new DigestPathDataSource(file, mediaType, lastModified);
        ds.md5 = md5;
        ds.sha256 = sha2;
        return ds;
    }

    public static int updatePrincipalDN(DataSource ds, Map<String, String> mapNodeDN) throws SQLException {
        int updated = 0;
        try (Connection dbc = ds.getConnection();
             PreparedStatement update_dn = dbc.prepareStatement("UPDATE nodes SET subject_dn=? WHERE client_key=?");){
            dbc.setAutoCommit(true);
            for (Map.Entry<String, String> entry : mapNodeDN.entrySet()) {
                update_dn.setString(1, entry.getValue());
                update_dn.setString(2, entry.getKey());
                updated += update_dn.executeUpdate();
            }
        }
        return updated;
    }

    /*
     * Exception decompiling
     */
    public List<RequestInfo> searchAllRequests(String mediaType, String searchLanguage, String predicate) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static enum Dbms {
        POSTGRES,
        HSQL;

    }

    @FunctionalInterface
    public static interface RequestInfoLoader {
        public RequestInfo load(ResultSet var1) throws SQLException;
    }

    private static class DatabasePrincipal
    extends Principal {
        private String dbSubjectDn;

        public DatabasePrincipal(int nodeId, AuthInfo info, String dbSubjectDn) {
            super(nodeId, info);
            this.dbSubjectDn = dbSubjectDn;
        }

        public String getDbSubjectDn() {
            return this.dbSubjectDn;
        }

        public void setDbSubjectDn(String dbSubjectDn) {
            this.dbSubjectDn = dbSubjectDn;
        }
    }
}

