/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.websocket;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.websocket.AbstractBroadcastWebsocket;
import org.aktin.broker.websocket.HeaderAuthSessionConfigurator;

@ServerEndpoint(value="/broker/my/websocket", configurator=HeaderAuthSessionConfigurator.class)
public class MyBrokerWebsocket
extends AbstractBroadcastWebsocket {
    public static final String REST_PATH = "/broker/my/websocket";
    private static final Logger log = Logger.getLogger(MyBrokerWebsocket.class.getName());
    private static Set<Session> clients = Collections.synchronizedSet(new HashSet());

    private static Set<Integer> integerArraySet(int[] values) {
        HashSet<Integer> nodes = new HashSet<Integer>(values.length);
        for (int i = 0; i < values.length; ++i) {
            nodes.add(values[i]);
        }
        return nodes;
    }

    private static void broadcastToSubset(String message, int[] nodeIds) {
        if (nodeIds == null) {
            MyBrokerWebsocket.broadcast(clients, message);
        } else {
            Set<Integer> nodes = MyBrokerWebsocket.integerArraySet(nodeIds);
            MyBrokerWebsocket.broadcast(clients, message, p -> nodes.contains(p.getNodeId()));
        }
    }

    public static void broadcastRequestPublished(int requestId, int[] nodeIds) {
        MyBrokerWebsocket.broadcastToSubset("published " + requestId, nodeIds);
    }

    public static void broadcastRequestClosed(int requestId, int[] nodeIds) {
        MyBrokerWebsocket.broadcastToSubset("closed " + requestId, nodeIds);
    }

    @Override
    protected boolean isAuthorized(Principal principal) {
        if (principal.isAdmin()) {
            log.info("Admin role not allowed for node websocket connections");
            return false;
        }
        return true;
    }

    @Override
    protected void addSession(Session session, Principal user) {
        user.incrementWebsocketCount();
        clients.add(session);
    }

    @Override
    protected void removeSession(Session session, Principal user) {
        user.decrementWebsocketCount();
        clients.remove(session);
    }
}

