/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.AuthRole;

public class Principal
implements java.security.Principal,
SecurityContext {
    private Integer nodeId;
    private String commonName;
    private String clientDn;
    private Set<AuthRole> roles;
    private long lastAccessed;
    private int websocketConnections;

    public Principal(int nodeId, AuthInfo info) {
        this(info);
        this.nodeId = nodeId;
    }

    private Principal(AuthInfo info) {
        this.clientDn = info.getClientDN();
        this.roles = info.getRoles();
        this.websocketConnections = 0;
        if (this.clientDn != null && this.clientDn.startsWith("CN=")) {
            int e = this.clientDn.indexOf(44);
            if (e == -1) {
                e = this.clientDn.length();
            }
            this.commonName = this.clientDn.substring(3, e);
        }
    }

    static Principal createAdminPrincipal(AuthInfo info) {
        Principal p = new Principal(info);
        p.nodeId = null;
        return p;
    }

    public boolean isNode() {
        return this.nodeId != null;
    }

    public String getClientDN() {
        return this.clientDn;
    }

    @Override
    public String getName() {
        if (this.commonName != null) {
            return this.commonName;
        }
        return Integer.toString(this.getNodeId());
    }

    public int getNodeId() throws UnsupportedOperationException {
        if (this.nodeId == null) {
            throw new UnsupportedOperationException("Principal is not a node: " + this.clientDn);
        }
        return this.nodeId;
    }

    public java.security.Principal getUserPrincipal() {
        return this;
    }

    public boolean isUserInRole(String role) {
        try {
            return this.roles.contains(AuthRole.valueOf((String)role));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isSecure() {
        return true;
    }

    public String getAuthenticationScheme() {
        return "CLIENT_CERT";
    }

    public boolean isAdmin() {
        return this.roles.contains(AuthRole.ADMIN_READ);
    }

    public void updateLastAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void incrementWebsocketCount() {
        ++this.websocketConnections;
    }

    public void decrementWebsocketCount() {
        --this.websocketConnections;
    }

    public int getWebsocketCount() {
        return this.websocketConnections;
    }

    @Override
    public String toString() {
        return "Principal(nodeId=" + this.nodeId + ", dn=" + this.clientDn + ")";
    }
}

