/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.rest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.download.Download;
import org.aktin.broker.download.DownloadManager;
import org.aktin.broker.download.RequestBundleExport;
import org.aktin.broker.rest.Authenticated;
import org.aktin.broker.rest.RequireAdmin;
import org.aktin.broker.server.DateDataSource;
import org.aktin.broker.util.FileStreamingResponse;
import org.aktin.broker.util.PathDataSource;
import org.aktin.broker.websocket.RequestAdminWebsocket;
import org.aktin.broker.xml.ResultList;

@Path(value="/aggregator/")
public class AggregatorEndpoint {
    private static final Logger log = Logger.getLogger(AggregatorEndpoint.class.getName());
    public static final String SERVICE_URL = "/aggregator/";
    @Inject
    private AggregatorBackend db;
    @Inject
    private DownloadManager downloads;

    private boolean isRequestWritable(int requestId, int nodeId) {
        return this.db.isRequestWritable(requestId, nodeId);
    }

    @Authenticated
    @PUT
    @Path(value="my/request/{id}/result")
    public void submitResult(@PathParam(value="id") String requestId, @HeaderParam(value="Content-type") MediaType type, @Context SecurityContext sec, InputStream content) throws URISyntaxException {
        Principal user = (Principal)sec.getUserPrincipal();
        if (type == null) {
            throw new BadRequestException("required Content-type header missing");
        }
        int nodeId = user.getNodeId();
        log.info("Result received from node " + nodeId + ": " + type.toString());
        int request = Integer.parseInt(requestId);
        if (!this.isRequestWritable(request, user.getNodeId())) {
            throw new ForbiddenException();
        }
        try {
            this.db.addOrReplaceResult(request, nodeId, type, content);
            RequestAdminWebsocket.broadcastNodeResult(request, nodeId, type.toString());
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to persist data", e);
            throw new InternalServerErrorException();
        }
    }

    @Authenticated
    @RequireAdmin
    @GET
    @Path(value="request/{id}/result")
    @Produces(value={"application/xml"})
    public ResultList listResultsForRequest(@PathParam(value="id") String requestId) {
        List results;
        int request = Integer.parseInt(requestId);
        try {
            results = this.db.listResults(request);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to list results from database", e);
            throw new InternalServerErrorException();
        }
        log.info("Found " + results.size() + " results");
        return new ResultList(results);
    }

    @Authenticated
    @RequireAdmin
    @DELETE
    @Path(value="request/{id}/result")
    public void deleteResultsForRequest(@PathParam(value="id") String requestId) {
        int request = Integer.parseInt(requestId);
        try {
            this.db.deleteResults(request);
        }
        catch (IOException | SQLException e) {
            log.log(Level.SEVERE, "Failed to delete results from database", e);
            throw new InternalServerErrorException();
        }
    }

    private DateDataSource getResultForNode(int requestId, int nodeId) throws InternalServerErrorException, NotFoundException {
        DateDataSource data;
        try {
            data = this.db.getResult(requestId, nodeId);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to retrieve data", e);
            throw new InternalServerErrorException((Throwable)e);
        }
        if (data == null) {
            throw new NotFoundException();
        }
        return data;
    }

    @Authenticated
    @RequireAdmin
    @POST
    @Produces(value={"text/plain"})
    @Path(value="request/{id}/result/{nodeId}/download")
    public String createResultNodeDownload(@PathParam(value="id") int requestId, @PathParam(value="nodeId") int nodeId) {
        DateDataSource data = this.getResultForNode(requestId, nodeId);
        String ext = RequestBundleExport.guessFileExtension(data.getContentType());
        if (ext == null) {
            ext = "";
        }
        Download download = this.downloads.createDataSourceDownload((DataSource)data, requestId + "_result_" + nodeId + ext);
        return download.getId().toString();
    }

    @Authenticated
    @RequireAdmin
    @GET
    @Path(value="request/{id}/result/{nodeId}")
    public Response getResultNodeDataStream(@PathParam(value="id") int requestId, @PathParam(value="nodeId") int nodeId) {
        DateDataSource data = this.getResultForNode(requestId, nodeId);
        if (!(data instanceof PathDataSource)) {
            throw new InternalServerErrorException("Unexpected interface for result data source");
        }
        PathDataSource path = (PathDataSource)data;
        return Response.ok((Object)new FileStreamingResponse(path.getPath()), (String)data.getContentType()).lastModified(Date.from(data.getLastModified())).header("Content-length", (Object)data.getContentLength()).build();
    }
}

