/*
 * Decompiled with CFR 0.152.
 */
package org.akubraproject.qsc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.transaction.Transaction;
import org.akubraproject.Blob;
import org.akubraproject.BlobStore;
import org.akubraproject.BlobStoreConnection;
import org.akubraproject.UnsupportedIdException;
import org.akubraproject.impl.BlobStoreConnectionWrapper;
import org.akubraproject.impl.StreamManager;
import org.akubraproject.qsc.QuiescingBlob;
import org.akubraproject.qsc.QuiescingStreamManager;

class QuiescingBlobStoreConnection
extends BlobStoreConnectionWrapper {
    private final Transaction transaction;
    private boolean modified = false;

    public QuiescingBlobStoreConnection(BlobStore store, BlobStoreConnection connection, Transaction tx, QuiescingStreamManager streamMgr) throws IOException {
        super(store, connection, (StreamManager)streamMgr);
        this.transaction = tx;
        streamMgr.register(this, tx);
    }

    public Blob getBlob(URI blobId, Map<String, String> hints) throws IOException, UnsupportedIdException, UnsupportedOperationException {
        Blob internalBlob = this.delegate.getBlob(blobId, hints);
        return new QuiescingBlob((BlobStoreConnection)this, internalBlob, this.streamManager);
    }

    public Blob getBlob(InputStream content, long estimatedSize, Map<String, String> hints) throws IOException, UnsupportedOperationException {
        this.waitUnquiescedAndMarkModified();
        Blob internalBlob = this.delegate.getBlob(content, estimatedSize, hints);
        return new QuiescingBlob((BlobStoreConnection)this, internalBlob, this.streamManager);
    }

    public void sync() throws IOException {
        this.waitUnquiescedAndMarkModified();
        this.delegate.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            super.close();
        }
        catch (Throwable throwable) {
            ((QuiescingStreamManager)this.streamManager).unregister(this, this.transaction != null);
            throw throwable;
        }
        ((QuiescingStreamManager)this.streamManager).unregister(this, this.transaction != null);
    }

    void waitUnquiescedAndMarkModified() throws IOException {
        ((QuiescingStreamManager)this.streamManager).lockUnquiesced();
        this.modified = true;
        ((QuiescingStreamManager)this.streamManager).unlockState();
    }

    boolean hasModifications() {
        return this.modified;
    }
}

