/*
 * Decompiled with CFR 0.152.
 */
package org.akubraproject.qsc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.akubraproject.BlobStoreConnection;
import org.akubraproject.impl.StreamManager;
import org.akubraproject.qsc.QuiescingBlobStoreConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuiescingStreamManager
extends StreamManager {
    private static final Logger log = LoggerFactory.getLogger(QuiescingStreamManager.class);
    private final ReentrantLock stateLock = new ReentrantLock(true);
    private final Condition becameUnquiescent = this.stateLock.newCondition();
    private boolean quiescent;
    private final Set<QuiescingBlobStoreConnection> txnCons = new HashSet<QuiescingBlobStoreConnection>();
    private final Set<QuiescingBlobStoreConnection> rawCons = new HashSet<QuiescingBlobStoreConnection>();

    QuiescingStreamManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(final QuiescingBlobStoreConnection con, Transaction tx) throws IOException {
        Set<QuiescingBlobStoreConnection> cons;
        if (tx != null) {
            try {
                tx.registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        QuiescingStreamManager.this.unregister(con, true);
                    }
                });
            }
            catch (Exception e) {
                throw new IOException("Error registering txn synchronization", e);
            }
            cons = this.txnCons;
        } else {
            cons = this.rawCons;
        }
        Set<QuiescingBlobStoreConnection> set = cons;
        synchronized (set) {
            cons.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(QuiescingBlobStoreConnection con, boolean transactional) {
        Set<QuiescingBlobStoreConnection> cons;
        Set<QuiescingBlobStoreConnection> set = cons = transactional ? this.txnCons : this.rawCons;
        synchronized (set) {
            if (cons.remove((Object)con)) {
                cons.notifyAll();
            }
        }
    }

    public void lockUnquiesced() throws IOException {
        boolean ok = false;
        try {
            this.stateLock.lockInterruptibly();
            while (this.quiescent) {
                log.info("lockUnquiesced: Waiting...", new Throwable());
                this.becameUnquiescent.await();
                log.info("lockUnquiesced: Wait is over.");
            }
            log.debug("Aquired the unquiescent lock");
            ok = true;
        }
        catch (InterruptedException ie) {
            throw new IOException("lockUnquiesced: interrupted", ie);
        }
        finally {
            if (!ok && this.stateLock.isHeldByCurrentThread()) {
                this.stateLock.unlock();
            }
        }
    }

    public void unlockState() {
        this.stateLock.unlock();
        log.debug("Released the unquiescent lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setQuiescent(boolean quiescent) throws IOException {
        try {
            this.stateLock.lockInterruptibly();
            if (quiescent && !this.quiescent) {
                Set<QuiescingBlobStoreConnection> set = this.openOutputStreams;
                synchronized (set) {
                    while (!this.openOutputStreams.isEmpty()) {
                        log.info("setQuiescent: Waiting for " + this.openOutputStreams.size() + " output streams to close...");
                        this.openOutputStreams.wait();
                    }
                }
                set = this.txnCons;
                synchronized (set) {
                    int cnt;
                    while ((cnt = this.countWriteTransactions()) > 0) {
                        log.info("setQuiescent: Waiting for " + cnt + " write transactions to close...");
                        this.txnCons.wait();
                    }
                }
                set = this.rawCons;
                synchronized (set) {
                    for (QuiescingBlobStoreConnection con : this.rawCons) {
                        if (!con.hasModifications()) continue;
                        con.sync();
                    }
                }
                log.info("setQuiescent: No open output streams or active write transactions. Entering quiescent state.");
            }
            if (!quiescent && this.quiescent) {
                log.info("setQuiescent: Exiting quiescent state.");
                this.becameUnquiescent.signalAll();
            }
            this.quiescent = quiescent;
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException ie) {
            if (quiescent) {
                log.warn("Interrupted while waiting to enter quiescent state", (Throwable)ie);
            } else {
                log.warn("Interrupted while waiting to exit quiescent state", (Throwable)ie);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.stateLock.isHeldByCurrentThread()) {
                this.stateLock.unlock();
            }
        }
    }

    private int countWriteTransactions() {
        int cnt = 0;
        for (QuiescingBlobStoreConnection con : this.txnCons) {
            if (!con.hasModifications()) continue;
            ++cnt;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream manageOutputStream(BlobStoreConnection con, OutputStream stream) throws IOException {
        this.lockIOE();
        try {
            OutputStream outputStream = super.manageOutputStream(con, stream);
            return outputStream;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void lockIOE() throws IOException {
        try {
            this.stateLock.lockInterruptibly();
        }
        catch (InterruptedException ie) {
            throw new IOException("Wait for state-lock interrupted", ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isQuiescent() {
        this.stateLock.lock();
        try {
            boolean bl = this.quiescent;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }
}

