/*
 * Decompiled with CFR 0.152.
 */
package org.akubraproject.www;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.akubraproject.Blob;
import org.akubraproject.BlobStoreConnection;
import org.akubraproject.DuplicateBlobException;
import org.akubraproject.MissingBlobException;
import org.akubraproject.impl.AbstractBlob;
import org.akubraproject.impl.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WWWBlob
extends AbstractBlob {
    private static final Logger logger = LoggerFactory.getLogger(WWWBlob.class);
    private final URL url;
    private final StreamManager streamManager;
    private Long size;
    private Boolean exists;
    private URLConnection urlc;
    private InputStream content;

    public WWWBlob(URL url, BlobStoreConnection conn, StreamManager streamManager) {
        super(conn, WWWBlob.toURI(url));
        this.url = url;
        this.streamManager = streamManager;
    }

    private static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new Error("unexpected exception", e);
        }
    }

    void closed() {
        this.urlc = null;
        this.exists = null;
        this.size = null;
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (IOException ioe) {
                logger.warn("Error closing input-stream for '" + this.id + "'", (Throwable)ioe);
            }
        }
    }

    private URLConnection connect(boolean input, boolean cache) throws IOException {
        URLConnection con;
        this.ensureOpen();
        if (this.urlc != null && input) {
            con = this.urlc;
        } else {
            con = this.url.openConnection();
            con.setAllowUserInteraction(false);
            if (input) {
                con.setDoInput(true);
            } else {
                con.setDoOutput(true);
            }
        }
        if (input) {
            try {
                this.content = this.streamManager.manageInputStream(this.owner, con.getInputStream());
                this.exists = true;
            }
            catch (FileNotFoundException fnfe) {
                logger.debug("blob doesn't exist for '" + this.id + "'", (Throwable)fnfe);
                this.exists = false;
                this.size = null;
                this.urlc = null;
                throw new MissingBlobException(this.id);
            }
            this.size = con.getContentLength();
            this.urlc = cache ? con : null;
        }
        return con;
    }

    public long getSize() throws IOException {
        if (this.exists != null && !this.exists.booleanValue()) {
            throw new MissingBlobException(this.id);
        }
        if (this.size == null) {
            this.connect(true, true);
        }
        return this.size;
    }

    public InputStream openInputStream() throws IOException {
        this.connect(true, false);
        return this.content;
    }

    public OutputStream openOutputStream(long estimatedSize, boolean overwrite) throws IOException {
        if (!overwrite && this.exists()) {
            throw new DuplicateBlobException(this.id);
        }
        URLConnection con = this.connect(false, false);
        OutputStream os = this.streamManager.manageOutputStream(this.owner, con.getOutputStream());
        this.exists = true;
        return os;
    }

    public boolean exists() throws IOException {
        if (this.exists == null) {
            try {
                this.connect(true, true);
            }
            catch (MissingBlobException mbe) {
                logger.trace("blob doesn't exist for '" + this.id + "'", (Throwable)mbe);
                return false;
            }
        }
        return this.exists;
    }

    public void delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Blob moveTo(URI blobId, Map<String, String> hints) throws IOException {
        throw new UnsupportedOperationException();
    }
}

