/*
 * Decompiled with CFR 0.152.
 */
package org.akubraproject.www;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.akubraproject.Blob;
import org.akubraproject.BlobStore;
import org.akubraproject.BlobStoreConnection;
import org.akubraproject.UnsupportedIdException;
import org.akubraproject.impl.AbstractBlobStoreConnection;
import org.akubraproject.impl.StreamManager;
import org.akubraproject.www.WWWBlob;
import org.akubraproject.www.WWWStore;

class WWWConnection
extends AbstractBlobStoreConnection {
    private final Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();
    private Map<URI, WWWBlob> blobs = new HashMap<URI, WWWBlob>();

    public WWWConnection(WWWStore store, Map<String, URLStreamHandler> handlers, StreamManager streamManager) {
        super((BlobStore)store, streamManager);
        if (handlers != null) {
            this.handlers.putAll(handlers);
        }
    }

    public void close() {
        if (this.blobs != null) {
            for (WWWBlob blob : this.blobs.values()) {
                blob.closed();
            }
            this.blobs.clear();
            this.blobs = null;
        }
        super.close();
    }

    WWWBlob getWWWBlob(URI blobId, boolean create) throws IOException {
        if (this.blobs == null) {
            throw new IllegalStateException("Connection closed.");
        }
        if (blobId == null) {
            throw new UnsupportedOperationException("Must supply a valid URL as the blob-id. This store has no id generation capability.");
        }
        WWWBlob blob = this.blobs.get(blobId);
        if (blob == null && create) {
            try {
                URL url = new URL(null, blobId.toString(), this.handlers.get(blobId.getScheme()));
                blob = new WWWBlob(url, (BlobStoreConnection)this, this.streamManager);
            }
            catch (MalformedURLException e) {
                throw new UnsupportedIdException(blobId, " must be a valid URL", (Throwable)e);
            }
            this.blobs.put(blobId, blob);
        }
        return blob;
    }

    public Blob getBlob(URI blobId, Map<String, String> hints) throws IOException, IllegalArgumentException {
        return this.getWWWBlob(blobId, true);
    }

    public Iterator<URI> listBlobIds(String filterPrefix) throws IOException {
        throw new UnsupportedOperationException("blob-id listing not supported");
    }

    public void sync() throws IOException {
        throw new UnsupportedOperationException("sync'ing not supported");
    }
}

