/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessBoardPath;
import org.alcibiade.chess.model.ChessMovePath;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.ChessPieceType;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.model.ChessSide;
import org.alcibiade.chess.model.IllegalMoveException;
import org.alcibiade.chess.model.PgnMoveException;
import org.alcibiade.chess.persistence.PgnBookReader;
import org.alcibiade.chess.persistence.PgnMarshaller;
import org.alcibiade.chess.rules.Castling;
import org.alcibiade.chess.rules.ChessHelper;
import org.alcibiade.chess.rules.ChessRules;
import org.alcibiade.chess.rules.PieceLocator;
import org.alcibiade.chess.rules.PieceMoveManager;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PgnMarshallerImpl
implements PgnMarshaller {
    private Logger log = LoggerFactory.getLogger(PgnMarshallerImpl.class);
    @Autowired
    private ChessRules chessRules;

    public PgnMarshallerImpl() {
    }

    public PgnMarshallerImpl(ChessRules chessRules) {
        this.chessRules = chessRules;
    }

    @Override
    public String convertMoveToPgn(ChessPosition position, ChessMovePath move) throws IllegalMoveException {
        String checkMark;
        String result = null;
        ChessPiece wk = new ChessPiece(ChessPieceType.KING, ChessSide.WHITE);
        ChessPiece bk = new ChessPiece(ChessPieceType.KING, ChessSide.BLACK);
        ChessBoardCoord e8 = new ChessBoardCoord("e8");
        ChessBoardCoord e1 = new ChessBoardCoord("e1");
        String string = checkMark = ChessHelper.isCheck(this.chessRules, position, move, true) ? "+" : "";
        result = move.equals(Castling.CASTLEBLACKK) && ObjectUtils.equals((Object)bk, (Object)position.getPiece(e8)) ? "O-O" + checkMark : (move.equals(Castling.CASTLEBLACKQ) && ObjectUtils.equals((Object)bk, (Object)position.getPiece(e8)) ? "O-O-O" + checkMark : (move.equals(Castling.CASTLEWHITEK) && ObjectUtils.equals((Object)wk, (Object)position.getPiece(e1)) ? "O-O" + checkMark : (move.equals(Castling.CASTLEWHITEQ) && ObjectUtils.equals((Object)wk, (Object)position.getPiece(e1)) ? "O-O-O" + checkMark : this.dumpStandardMove(position, move, checkMark))));
        return result;
    }

    private String dumpStandardMove(ChessPosition position, ChessMovePath move, String checkMark) throws IllegalMoveException {
        boolean isPawnAttack;
        boolean isCapture;
        ChessPiece pieceSrc = position.getPiece(move.getSource());
        ChessPiece pieceDst = position.getPiece(move.getDestination());
        PieceLocator pieceLocator = new PieceLocator(position);
        PieceMoveManager moveManager = new PieceMoveManager(position);
        boolean bl = isCapture = pieceDst != null;
        if (pieceSrc == null) {
            throw new IllegalMoveException(move.getSource());
        }
        if (pieceSrc.getType() == ChessPieceType.PAWN && move.getSource().getCol() != move.getDestination().getCol()) {
            isCapture = true;
        }
        StringBuilder pgn = new StringBuilder();
        if (pieceSrc.getType() != ChessPieceType.PAWN) {
            pgn.append(pieceSrc.getType().getShortName().toUpperCase());
        }
        boolean showSourceCol = false;
        boolean showSourceRow = false;
        boolean otherPieceCanReach = false;
        ChessBoardCoord source = move.getSource();
        Set<ChessBoardCoord> samePieces = pieceLocator.locatePiece(pieceSrc);
        samePieces.remove(move.getSource());
        for (ChessBoardCoord samePiece : samePieces) {
            Set<ChessBoardCoord> reachable = moveManager.getReachableSquares(samePiece, this.chessRules);
            if (!reachable.contains(move.getDestination())) continue;
            otherPieceCanReach = true;
            if (samePiece.getCol() == source.getCol()) {
                showSourceRow = true;
            }
            if (samePiece.getRow() != source.getRow()) continue;
            showSourceCol = true;
        }
        boolean bl2 = isPawnAttack = pieceSrc.getType() == ChessPieceType.PAWN && isCapture;
        if (!showSourceCol && !showSourceRow && (isPawnAttack || otherPieceCanReach)) {
            showSourceCol = true;
        }
        String sourcePgn = source.getPgnCoordinates();
        if (showSourceCol) {
            pgn.append(sourcePgn.charAt(0));
        }
        if (showSourceRow) {
            pgn.append(sourcePgn.charAt(1));
        }
        if (isCapture) {
            pgn.append("x");
        }
        pgn.append(move.getDestination().getPgnCoordinates());
        pgn.append(checkMark);
        if (pieceSrc.getType() == ChessPieceType.PAWN && (move.getDestination().getRow() == 7 && pieceSrc.getSide() == ChessSide.WHITE || move.getDestination().getRow() == 0 && pieceSrc.getSide() == ChessSide.BLACK)) {
            pgn.append("=");
            pgn.append(move.getPromotedPieceType().getShortName().toUpperCase());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Position is " + position.toString());
            this.log.debug("Creating PGN notation for move " + move);
            this.log.debug("Possible sources are " + samePieces);
            this.log.debug("PGN: " + pgn);
        }
        return pgn.toString();
    }

    @Override
    public ChessMovePath convertPgnToMove(ChessPosition position, String pgnMove) throws PgnMoveException {
        ChessMovePath path = null;
        String trimmedPgn = pgnMove.trim();
        path = StringUtils.startsWithIgnoreCase((String)trimmedPgn, (String)"O-O-O") ? (position.getNextPlayerTurn() == ChessSide.WHITE ? Castling.CASTLEWHITEQ : Castling.CASTLEBLACKQ) : (StringUtils.startsWithIgnoreCase((String)trimmedPgn, (String)"O-O") ? (position.getNextPlayerTurn() == ChessSide.WHITE ? Castling.CASTLEWHITEK : Castling.CASTLEBLACKK) : this.parseStandardMove(trimmedPgn, position));
        return path;
    }

    protected ChessMovePath parseStandardMove(String pgnMove, ChessPosition position) throws PgnMoveException {
        Pattern pgnPattern = Pattern.compile("([RNBQKP]?)([a-h]?)([1-8]?)([x-]?)([a-h][1-8])\\+?=?([RNBQ])?([\\+#])?");
        Matcher pgnMatcher = pgnPattern.matcher(pgnMove);
        if (!pgnMatcher.matches()) {
            throw new PgnMoveException(pgnMove, "Does not match PGN syntax");
        }
        String pgnPiece = pgnMatcher.group(1);
        String pgnSourceX = pgnMatcher.group(2);
        String pgnSourceY = pgnMatcher.group(3);
        String pgnDestination = pgnMatcher.group(5);
        String pgnPromotion = pgnMatcher.group(6);
        if (pgnPiece.isEmpty() && !pgnSourceX.isEmpty() && !pgnSourceY.isEmpty()) {
            ChessBoardCoord sourceCoord = new ChessBoardCoord(pgnSourceX + pgnSourceY);
            ChessPiece piece = position.getPiece(sourceCoord);
            pgnPiece = piece.getType().getShortName();
        }
        ChessBoardCoord dst = new ChessBoardCoord(pgnDestination);
        Set<ChessMovePath> availableMoves = this.chessRules.getAvailableMoves(position);
        HashSet<ChessBoardCoord> selectedSources = new HashSet<ChessBoardCoord>();
        for (ChessBoardPath chessBoardPath : availableMoves) {
            if (!ObjectUtils.equals((Object)chessBoardPath.getDestination(), (Object)dst)) continue;
            ChessBoardCoord attacker = chessBoardPath.getSource();
            ChessPiece piece = position.getPiece(attacker);
            assert (piece != null);
            boolean selected = true;
            if (StringUtils.isEmpty((String)pgnPiece)) {
                if (!StringUtils.equalsIgnoreCase((String)piece.getType().getShortName(), (String)ChessPieceType.PAWN.getShortName())) {
                    selected = false;
                }
            } else if (!StringUtils.equalsIgnoreCase((String)piece.getType().getShortName(), (String)pgnPiece)) {
                selected = false;
            }
            if (StringUtils.isNotEmpty((String)pgnSourceX) && ChessBoardCoord.getColFromName(pgnSourceX) != attacker.getCol()) {
                selected = false;
            }
            if (StringUtils.isNotEmpty((String)pgnSourceY) && ChessBoardCoord.getRowFromName(pgnSourceY) != attacker.getRow()) {
                selected = false;
            }
            if (!selected) continue;
            selectedSources.add(attacker);
        }
        if (selectedSources.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(position.toString());
                this.log.debug(availableMoves.toString());
            }
            throw new PgnMoveException(pgnMove, "No piece can reach square " + pgnDestination);
        }
        if (selectedSources.size() > 1) {
            throw new PgnMoveException(pgnMove, "Several pieces can reach square " + pgnDestination);
        }
        ChessPieceType promoted = ChessPieceType.QUEEN;
        if (StringUtils.isNotEmpty((String)pgnPromotion)) {
            this.log.debug("PGN promotion is {}", (Object)pgnPromotion);
            assert (pgnPromotion.length() == 1);
            promoted = ChessPieceType.getPgnType(pgnPromotion);
            assert (promoted != null);
        }
        ChessBoardCoord chessBoardCoord = (ChessBoardCoord)selectedSources.iterator().next();
        ChessMovePath path = new ChessMovePath(chessBoardCoord, dst, promoted);
        return path;
    }

    @Override
    public String exportGame(String white, String black, Date startDate, Collection<String> moves) {
        StringBuilder pgn = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");
        this.appendPgnHeader(pgn, "White", white);
        this.appendPgnHeader(pgn, "Black", black);
        this.appendPgnHeader(pgn, "Date", df.format(startDate));
        pgn.append("\n");
        StringBuilder line = new StringBuilder();
        int index = 0;
        for (String move : moves) {
            if (index % 2 == 0) {
                line.append(index / 2);
                line.append(". ");
            }
            line.append(move);
            line.append(' ');
            if (line.length() <= 70) continue;
            pgn.append((CharSequence)line);
            pgn.append("\n");
            line.setLength(0);
        }
        pgn.append((CharSequence)line);
        pgn.append("\n");
        return pgn.toString();
    }

    @Override
    public Collection<String> importGame(InputStream pgnStream) throws IOException {
        PgnBookReader bookReader = new PgnBookReader(pgnStream);
        return bookReader.readGame().getMoves();
    }

    private void appendPgnHeader(StringBuilder text, String name, String value) {
        text.append("[");
        text.append(name);
        text.append(" \"");
        text.append(value);
        text.append(" \"");
        text.append("]");
        text.append("\n");
    }
}

