/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessBoardModel;
import org.alcibiade.chess.model.ChessBoardPath;
import org.alcibiade.chess.model.ChessGameStatus;
import org.alcibiade.chess.model.ChessMovePath;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.ChessPieceType;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.model.ChessSide;
import org.alcibiade.chess.model.IllegalMoveException;
import org.alcibiade.chess.model.boardupdates.ChessBoardUpdate;
import org.alcibiade.chess.model.boardupdates.FlagUpdateCastling;
import org.alcibiade.chess.model.boardupdates.FlagUpdatePawn;
import org.alcibiade.chess.model.boardupdates.PieceUpdateAdd;
import org.alcibiade.chess.model.boardupdates.PieceUpdateMove;
import org.alcibiade.chess.model.boardupdates.PieceUpdateRemove;
import org.alcibiade.chess.rules.Castling;
import org.alcibiade.chess.rules.ChessHelper;
import org.alcibiade.chess.rules.ChessRules;
import org.alcibiade.chess.rules.PieceLocator;
import org.alcibiade.chess.rules.PieceMoveManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChessRulesImpl
implements ChessRules {
    private Logger log = LoggerFactory.getLogger(ChessRulesImpl.class);

    @Override
    public Set<ChessMovePath> getAvailableMoves(ChessPosition position) {
        HashSet<ChessMovePath> availableMoves = new HashSet<ChessMovePath>();
        ChessSide side = position.getNextPlayerTurn();
        PieceLocator locator = new PieceLocator(position);
        for (ChessBoardCoord pieceCoord : locator.locatePieces(side)) {
            for (ChessBoardCoord destination : this.getReachableDestinations(position, pieceCoord, true)) {
                ChessMovePath path = new ChessMovePath(pieceCoord, destination);
                try {
                    boolean check = ChessHelper.isCheck(this, position, path, false);
                    if (check) continue;
                    availableMoves.add(path);
                }
                catch (IllegalMoveException ex) {
                    this.log.warn("Failed to compute available moves", (Throwable)ex);
                }
            }
        }
        return availableMoves;
    }

    @Override
    public Set<ChessBoardCoord> getReachableDestinations(ChessPosition position, ChessBoardCoord pieceCoords, boolean excludeCheckSituations) {
        PieceMoveManager moveManager = new PieceMoveManager(position);
        return moveManager.getReachableSquares(pieceCoords, excludeCheckSituations ? this : null);
    }

    @Override
    public Set<ChessBoardCoord> getAttackingPieces(ChessPosition position, ChessBoardCoord squarePosition) {
        HashSet<ChessBoardCoord> result = new HashSet<ChessBoardCoord>();
        ChessSide player = position.getNextPlayerTurn();
        ChessSide opponent = player.opposite();
        ChessBoardModel boardModel = new ChessBoardModel();
        boardModel.setPosition(position);
        boardModel.setPiece(squarePosition, new ChessPiece(ChessPieceType.PAWN, player));
        PieceLocator locator = new PieceLocator(boardModel);
        for (ChessBoardCoord pieceCoord : locator.locatePieces(opponent)) {
            Set<ChessBoardCoord> destinations = this.getReachableDestinations(boardModel, pieceCoord, false);
            if (!destinations.contains(squarePosition)) continue;
            result.add(pieceCoord);
        }
        return result;
    }

    @Override
    public ChessPosition getInitialPosition() {
        ChessBoardModel boardmodel = new ChessBoardModel();
        boardmodel.setInitialPosition();
        return boardmodel;
    }

    @Override
    public ChessGameStatus getStatus(ChessPosition position) {
        ChessGameStatus status = ChessGameStatus.OPEN;
        if (this.getAvailableMoves(position).isEmpty()) {
            PieceLocator locator = new PieceLocator(position);
            ChessSide nextPlayer = position.getNextPlayerTurn();
            ChessPiece playerKing = new ChessPiece(ChessPieceType.KING, nextPlayer);
            ChessBoardCoord kingPosition = locator.locatePiece(playerKing).iterator().next();
            status = this.getAttackingPieces(position, kingPosition).isEmpty() ? ChessGameStatus.PAT : (nextPlayer == ChessSide.WHITE ? ChessGameStatus.BLACKWON : ChessGameStatus.WHITEWON);
        }
        return status;
    }

    @Override
    public List<ChessBoardUpdate> getUpdatesForMove(ChessPosition position, ChessMovePath path) throws IllegalMoveException {
        ChessBoardCoord destination;
        int destinationRow;
        ArrayList<ChessBoardUpdate> updates = new ArrayList<ChessBoardUpdate>();
        ChessPiece movedPiece = position.getPiece(path.getSource());
        if (movedPiece == null) {
            throw new IllegalMoveException(path.getSource());
        }
        ChessPieceType pieceType = movedPiece.getType();
        ChessSide player = position.getNextPlayerTurn();
        ChessPiece targetPiece = position.getPiece(path.getDestination());
        if (targetPiece != null) {
            updates.add(new PieceUpdateRemove(path.getDestination()));
        }
        this.considerCastlingMoves(position, path, updates, pieceType, player);
        this.considerRookImpacts(position, path, updates, pieceType, player, targetPiece);
        if (pieceType == ChessPieceType.PAWN && path.get8Distance() == 2) {
            updates.add(new FlagUpdatePawn(path.getDestination()));
        } else if (position.getLastPawnDMove() != null) {
            updates.add(new FlagUpdatePawn(null));
        }
        updates.add(new PieceUpdateMove(path));
        if (pieceType == ChessPieceType.PAWN && ((destinationRow = (destination = path.getDestination()).getRow()) == 0 || destinationRow == 7)) {
            updates.add(new PieceUpdateRemove(destination));
            updates.add(new PieceUpdateAdd(destination, new ChessPiece(path.getPromotedPieceType(), player)));
        }
        if (pieceType == ChessPieceType.PAWN && targetPiece == null && path.getSource().getCol() != path.getDestination().getCol()) {
            updates.add(new PieceUpdateRemove(new ChessBoardCoord(path.getDestination().getCol(), path.getSource().getRow())));
        }
        return updates;
    }

    private void considerRookImpacts(ChessPosition position, ChessMovePath path, List<ChessBoardUpdate> updates, ChessPieceType pieceType, ChessSide player, ChessPiece targetPiece) {
        int row;
        if (pieceType == ChessPieceType.ROOK) {
            int n = row = player == ChessSide.WHITE ? 0 : 7;
            if (path.getSource().equals(new ChessBoardCoord(0, row))) {
                this.addCastlingFlagIfRequired(position, updates, player, false);
            } else if (path.getSource().equals(new ChessBoardCoord(7, row))) {
                this.addCastlingFlagIfRequired(position, updates, player, true);
            }
        }
        if (targetPiece != null && targetPiece.getType() == ChessPieceType.ROOK) {
            row = player == ChessSide.WHITE ? 7 : 0;
            ChessBoardCoord dest = path.getDestination();
            if (dest.getRow() == row) {
                if (dest.getCol() == 0) {
                    this.addCastlingFlagIfRequired(position, updates, player.opposite(), false);
                } else if (dest.getCol() == 7) {
                    this.addCastlingFlagIfRequired(position, updates, player.opposite(), true);
                }
            }
        }
    }

    private void considerCastlingMoves(ChessPosition position, ChessMovePath path, List<ChessBoardUpdate> updates, ChessPieceType pieceType, ChessSide player) throws IllegalMoveException {
        if (pieceType == ChessPieceType.KING) {
            if (path.equals(Castling.CASTLEWHITEQ)) {
                if (!position.isCastlingAvailable(ChessSide.WHITE, false)) {
                    throw new IllegalMoveException(path, "White queenside castling not available");
                }
                updates.add(new PieceUpdateMove(new ChessBoardPath("a1", "d1")));
            } else if (path.equals(Castling.CASTLEWHITEK)) {
                if (!position.isCastlingAvailable(ChessSide.WHITE, true)) {
                    throw new IllegalMoveException(path, "White kingside castling not available");
                }
                updates.add(new PieceUpdateMove(new ChessBoardPath("h1", "f1")));
            } else if (path.equals(Castling.CASTLEBLACKQ)) {
                if (!position.isCastlingAvailable(ChessSide.BLACK, false)) {
                    throw new IllegalMoveException(path, "Black queenside castling not available");
                }
                updates.add(new PieceUpdateMove(new ChessBoardPath("a8", "d8")));
            } else if (path.equals(Castling.CASTLEBLACKK)) {
                if (!position.isCastlingAvailable(ChessSide.BLACK, true)) {
                    throw new IllegalMoveException(path, "Black kingside castling not available");
                }
                updates.add(new PieceUpdateMove(new ChessBoardPath("h8", "f8")));
            }
            this.addCastlingFlagIfRequired(position, updates, player, true);
            this.addCastlingFlagIfRequired(position, updates, player, false);
        }
    }

    private void addCastlingFlagIfRequired(ChessPosition position, List<ChessBoardUpdate> updates, ChessSide side, boolean kingside) {
        if (position.isCastlingAvailable(side, kingside)) {
            updates.add(new FlagUpdateCastling(side, kingside));
        }
    }
}

