/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.rules;

import java.util.HashSet;
import java.util.Set;
import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.model.ChessSide;
import org.alcibiade.chess.rules.Castling;
import org.alcibiade.chess.rules.ChessRules;

public class PieceMoveManager {
    private ChessPosition position;

    public PieceMoveManager(ChessPosition position) {
        this.position = position;
    }

    public Set<ChessBoardCoord> getReachableSquares(ChessBoardCoord coord, ChessRules rules) {
        HashSet<ChessBoardCoord> reachable = new HashSet<ChessBoardCoord>();
        ChessPiece piece = this.position.getPiece(coord);
        if (piece != null) {
            ChessSide player = piece.getSide();
            int dy = player == ChessSide.WHITE ? 1 : -1;
            int baseRow = player == ChessSide.WHITE ? 0 : 7;
            switch (piece.getType()) {
                case PAWN: {
                    boolean frontIsFree = this.add(reachable, this.isFree(coord, 0, dy));
                    if (frontIsFree && coord.getRow() == baseRow + dy) {
                        this.add(reachable, this.isFree(coord, 0, dy * 2));
                    }
                    this.add(reachable, this.isOpponent(player, coord, 1, dy));
                    this.add(reachable, this.isOpponent(player, coord, -1, dy));
                    ChessBoardCoord lastPawn = this.position.getLastPawnDMove();
                    if (lastPawn == null) break;
                    int dx = lastPawn.getCol() - coord.getCol();
                    if (lastPawn.getRow() != coord.getRow() || Math.abs(dx) != 1) break;
                    this.add(reachable, this.isFree(coord, dx, dy));
                    break;
                }
                case KNIGHT: {
                    this.add(reachable, this.isOpponentOrFree(player, coord, 1, 2));
                    this.add(reachable, this.isOpponentOrFree(player, coord, -1, 2));
                    this.add(reachable, this.isOpponentOrFree(player, coord, -1, -2));
                    this.add(reachable, this.isOpponentOrFree(player, coord, 1, -2));
                    this.add(reachable, this.isOpponentOrFree(player, coord, 2, 1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, -2, 1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, -2, -1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, 2, -1));
                    break;
                }
                case KING: {
                    boolean positionOk;
                    this.add(reachable, this.isOpponentOrFree(player, coord, 1, 1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, 0, 1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, -1, 1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, 1, 0));
                    this.add(reachable, this.isOpponentOrFree(player, coord, -1, 0));
                    this.add(reachable, this.isOpponentOrFree(player, coord, 1, -1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, 0, -1));
                    this.add(reachable, this.isOpponentOrFree(player, coord, -1, -1));
                    if (this.position.isCastlingAvailable(player, true)) {
                        positionOk = this.position.getPiece(new ChessBoardCoord(5, baseRow)) == null;
                        boolean bl = positionOk = positionOk && this.position.getPiece(new ChessBoardCoord(6, baseRow)) == null;
                        if (rules != null) {
                            positionOk = positionOk && rules.getAttackingPieces(this.position, new ChessBoardCoord(4, baseRow)).isEmpty();
                            positionOk = positionOk && rules.getAttackingPieces(this.position, new ChessBoardCoord(5, baseRow)).isEmpty();
                            boolean bl2 = positionOk = positionOk && rules.getAttackingPieces(this.position, new ChessBoardCoord(6, baseRow)).isEmpty();
                        }
                        if (positionOk) {
                            this.add(reachable, player == ChessSide.WHITE ? Castling.CASTLEWHITEK.getDestination() : Castling.CASTLEBLACKK.getDestination());
                        }
                    }
                    if (!this.position.isCastlingAvailable(player, false)) break;
                    positionOk = this.position.getPiece(new ChessBoardCoord(1, baseRow)) == null;
                    positionOk = positionOk && this.position.getPiece(new ChessBoardCoord(2, baseRow)) == null;
                    boolean bl = positionOk = positionOk && this.position.getPiece(new ChessBoardCoord(3, baseRow)) == null;
                    if (rules != null) {
                        positionOk = positionOk && rules.getAttackingPieces(this.position, new ChessBoardCoord(1, baseRow)).isEmpty();
                        positionOk = positionOk && rules.getAttackingPieces(this.position, new ChessBoardCoord(2, baseRow)).isEmpty();
                        positionOk = positionOk && rules.getAttackingPieces(this.position, new ChessBoardCoord(3, baseRow)).isEmpty();
                        boolean bl3 = positionOk = positionOk && rules.getAttackingPieces(this.position, new ChessBoardCoord(4, baseRow)).isEmpty();
                    }
                    if (!positionOk) break;
                    this.add(reachable, player == ChessSide.WHITE ? Castling.CASTLEWHITEQ.getDestination() : Castling.CASTLEBLACKQ.getDestination());
                    break;
                }
                case ROOK: {
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 1, 0));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, -1, 0));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 0, 1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 0, -1));
                    break;
                }
                case BISHOP: {
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 1, 1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, -1, 1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 1, -1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, -1, -1));
                    break;
                }
                case QUEEN: {
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 1, 0));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, -1, 0));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 0, 1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 0, -1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 1, 1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, -1, 1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, 1, -1));
                    this.add(reachable, this.isOpponentOrFreeRecursive(player, coord, -1, -1));
                }
            }
        }
        return reachable;
    }

    private ChessBoardCoord isFree(ChessBoardCoord coord, int dx, int dy) {
        ChessBoardCoord result = null;
        ChessBoardCoord targetCoord = this.computeTargetCoord(coord, dx, dy);
        if (targetCoord != null && this.position.getPiece(targetCoord) == null) {
            result = targetCoord;
        }
        return result;
    }

    private ChessBoardCoord isOpponentOrFree(ChessSide player, ChessBoardCoord coord, int dx, int dy) {
        ChessBoardCoord result = this.isFree(coord, dx, dy);
        if (result == null) {
            result = this.isOpponent(player, coord, dx, dy);
        }
        return result;
    }

    private Set<ChessBoardCoord> isOpponentOrFreeRecursive(ChessSide player, ChessBoardCoord coord, int dx, int dy) {
        HashSet<ChessBoardCoord> result = new HashSet<ChessBoardCoord>();
        ChessBoardCoord targetCoord = this.isFree(coord, dx, dy);
        if (targetCoord == null) {
            targetCoord = this.isOpponent(player, coord, dx, dy);
        } else {
            result.addAll(this.isOpponentOrFreeRecursive(player, targetCoord, dx, dy));
        }
        if (targetCoord != null) {
            result.add(targetCoord);
        }
        return result;
    }

    private ChessBoardCoord isOpponent(ChessSide player, ChessBoardCoord coord, int dx, int dy) {
        ChessPiece coordPiece;
        ChessBoardCoord result = null;
        ChessBoardCoord targetCoord = this.computeTargetCoord(coord, dx, dy);
        if (targetCoord != null && (coordPiece = this.position.getPiece(targetCoord)) != null && coordPiece.getSide() != player) {
            result = targetCoord;
        }
        return result;
    }

    private boolean add(Set<ChessBoardCoord> reachable, ChessBoardCoord coord) {
        boolean result = false;
        if (coord != null) {
            reachable.add(coord);
            result = true;
        }
        return result;
    }

    private boolean add(Set<ChessBoardCoord> reachable, Set<ChessBoardCoord> coords) {
        boolean result = false;
        if (coords != null) {
            reachable.addAll(coords);
            result = true;
        }
        return result;
    }

    private ChessBoardCoord computeTargetCoord(ChessBoardCoord coord, int dx, int dy) {
        ChessBoardCoord targetCoord = null;
        if (this.isBetween(0, coord.getCol() + dx, 8) && this.isBetween(0, coord.getRow() + dy, 8)) {
            targetCoord = coord.add(dx, dy);
        }
        return targetCoord;
    }

    private boolean isBetween(int a, int x, int b) {
        return a <= x && x < b;
    }
}

