/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model;

public enum ChessPieceType {
    PAWN("p", "pawn"),
    KNIGHT("n", "knight"),
    BISHOP("b", "bishop"),
    ROOK("r", "rook"),
    QUEEN("q", "queen"),
    KING("k", "king");

    private final String shortName;
    private final String fullName;

    private ChessPieceType(String shortName, String fullName) {
        this.shortName = shortName;
        this.fullName = fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static ChessPieceType getPgnType(String s) {
        ChessPieceType result = null;
        for (ChessPieceType type : ChessPieceType.values()) {
            if (!type.getShortName().equalsIgnoreCase(s)) continue;
            result = type;
            break;
        }
        return result;
    }

    public String toString() {
        return this.fullName;
    }
}

