/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model;

import java.io.Serializable;
import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.ChessPieceType;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.model.ChessSide;
import org.apache.commons.lang.ObjectUtils;

public class ChessBoardModel
implements ChessPosition,
Serializable {
    private static final long serialVersionUID = 1L;
    private ChessPiece[] pieces = new ChessPiece[64];
    private boolean[] castlingFlags = new boolean[4];
    private ChessBoardCoord lastPawnDMove = null;
    private ChessSide nextPlayerTurn = ChessSide.WHITE;

    public void setPosition(ChessPosition position) {
        if (position instanceof ChessBoardModel) {
            ChessBoardModel otherModel = (ChessBoardModel)position;
            System.arraycopy(otherModel.pieces, 0, this.pieces, 0, 64);
            System.arraycopy(otherModel.castlingFlags, 0, this.castlingFlags, 0, 4);
        } else {
            for (ChessBoardCoord coord : ChessBoardCoord.getAllBoardCoords()) {
                this.setPiece(coord, position.getPiece(coord));
            }
            this.castlingFlags[0] = position.isCastlingAvailable(ChessSide.WHITE, true);
            this.castlingFlags[1] = position.isCastlingAvailable(ChessSide.WHITE, false);
            this.castlingFlags[2] = position.isCastlingAvailable(ChessSide.BLACK, true);
            this.castlingFlags[3] = position.isCastlingAvailable(ChessSide.BLACK, false);
        }
        this.nextPlayerTurn = position.getNextPlayerTurn();
        this.lastPawnDMove = position.getLastPawnDMove();
    }

    @Override
    public ChessPiece getPiece(ChessBoardCoord coord) {
        return this.pieces[coord.getOffset()];
    }

    public void setPiece(ChessBoardCoord coord, ChessPiece piece) {
        this.pieces[coord.getOffset()] = piece;
    }

    public void clearSquare(ChessBoardCoord coord) {
        this.pieces[coord.getOffset()] = null;
    }

    public void clear() {
        for (int i = 0; i < 64; ++i) {
            this.pieces[i] = null;
        }
    }

    public void movePiece(ChessBoardCoord src, ChessBoardCoord dst) {
        assert (this.pieces[src.getOffset()] != null);
        this.pieces[dst.getOffset()] = this.pieces[src.getOffset()];
        this.pieces[src.getOffset()] = null;
    }

    public void setInitialPosition() {
        this.clear();
        for (int i = 0; i < 8; ++i) {
            this.pieces[8 + i] = new ChessPiece(ChessPieceType.PAWN, ChessSide.WHITE);
            this.pieces[48 + i] = new ChessPiece(ChessPieceType.PAWN, ChessSide.BLACK);
        }
        this.setPiece(new ChessBoardCoord(0, 0), new ChessPiece(ChessPieceType.ROOK, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(1, 0), new ChessPiece(ChessPieceType.KNIGHT, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(2, 0), new ChessPiece(ChessPieceType.BISHOP, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(3, 0), new ChessPiece(ChessPieceType.QUEEN, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(4, 0), new ChessPiece(ChessPieceType.KING, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(5, 0), new ChessPiece(ChessPieceType.BISHOP, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(6, 0), new ChessPiece(ChessPieceType.KNIGHT, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(7, 0), new ChessPiece(ChessPieceType.ROOK, ChessSide.WHITE));
        this.setPiece(new ChessBoardCoord(0, 7), new ChessPiece(ChessPieceType.ROOK, ChessSide.BLACK));
        this.setPiece(new ChessBoardCoord(1, 7), new ChessPiece(ChessPieceType.KNIGHT, ChessSide.BLACK));
        this.setPiece(new ChessBoardCoord(2, 7), new ChessPiece(ChessPieceType.BISHOP, ChessSide.BLACK));
        this.setPiece(new ChessBoardCoord(3, 7), new ChessPiece(ChessPieceType.QUEEN, ChessSide.BLACK));
        this.setPiece(new ChessBoardCoord(4, 7), new ChessPiece(ChessPieceType.KING, ChessSide.BLACK));
        this.setPiece(new ChessBoardCoord(5, 7), new ChessPiece(ChessPieceType.BISHOP, ChessSide.BLACK));
        this.setPiece(new ChessBoardCoord(6, 7), new ChessPiece(ChessPieceType.KNIGHT, ChessSide.BLACK));
        this.setPiece(new ChessBoardCoord(7, 7), new ChessPiece(ChessPieceType.ROOK, ChessSide.BLACK));
        this.castlingFlags[0] = true;
        this.castlingFlags[1] = true;
        this.castlingFlags[2] = true;
        this.castlingFlags[3] = true;
        this.lastPawnDMove = null;
        this.nextPlayerTurn = ChessSide.WHITE;
    }

    @Override
    public boolean isCastlingAvailable(ChessSide side, boolean kingside) {
        boolean result = side == ChessSide.BLACK ? (kingside ? this.castlingFlags[2] : this.castlingFlags[3]) : (kingside ? this.castlingFlags[0] : this.castlingFlags[1]);
        return result;
    }

    public void setCastlingAvailable(ChessSide side, boolean kingside, boolean available) {
        if (side == ChessSide.BLACK) {
            if (kingside) {
                this.castlingFlags[2] = available;
            } else {
                this.castlingFlags[3] = available;
            }
        } else if (kingside) {
            this.castlingFlags[0] = available;
        } else {
            this.castlingFlags[1] = available;
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ChessBoardModel) {
            int i;
            ChessBoardModel oModel = (ChessBoardModel)obj;
            result = true;
            for (i = 0; i < this.castlingFlags.length; ++i) {
                result = result && this.castlingFlags[i] == oModel.castlingFlags[i];
            }
            for (i = 0; i < 64; ++i) {
                result = result && ObjectUtils.equals((Object)this.pieces[i], (Object)oModel.pieces[i]);
            }
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < 64; ++i) {
            result += ObjectUtils.hashCode((Object)this.pieces[i]);
        }
        return result;
    }

    public void nextPlayerTurn() {
        this.setNextPlayerTurn(this.getNextPlayerTurn().opposite());
    }

    @Override
    public ChessSide getNextPlayerTurn() {
        return this.nextPlayerTurn;
    }

    public void setNextPlayerTurn(ChessSide nextPlayerTurn) {
        this.nextPlayerTurn = nextPlayerTurn;
    }

    @Override
    public ChessBoardCoord getLastPawnDMove() {
        return this.lastPawnDMove;
    }

    public void setLastPawnDMove(ChessBoardCoord lastPawnDMove) {
        this.lastPawnDMove = lastPawnDMove;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append((Object)this.nextPlayerTurn);
        text.append(' ');
        text.append(this.castlingFlags[0] ? "K" : "");
        text.append(this.castlingFlags[1] ? "Q" : "");
        text.append(this.castlingFlags[2] ? "k" : "");
        text.append(this.castlingFlags[3] ? "q" : "");
        if (this.lastPawnDMove != null) {
            text.append(' ');
            text.append(this.lastPawnDMove.getPgnCoordinates());
        }
        text.append('\n');
        for (int row = 7; row >= 0; --row) {
            for (int col = 0; col < 8; ++col) {
                ChessPiece piece = this.getPiece(new ChessBoardCoord(col, row));
                if (piece == null) {
                    text.append('.');
                } else if (piece.getSide() == ChessSide.WHITE) {
                    text.append(piece.getType().getShortName().toUpperCase());
                } else {
                    text.append(piece.getType().getShortName().toLowerCase());
                }
                text.append(' ');
            }
            text.append('\n');
        }
        return text.toString();
    }
}

