/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model;

import java.io.Serializable;
import org.alcibiade.chess.model.ChessBoardCoord;

public class ChessBoardPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ChessBoardCoord source;
    private ChessBoardCoord destination;

    protected ChessBoardPath() {
    }

    public ChessBoardPath(String source, String destination) {
        assert (source != null && destination != null);
        this.source = new ChessBoardCoord(source);
        this.destination = new ChessBoardCoord(destination);
    }

    public ChessBoardPath(ChessBoardCoord source, ChessBoardCoord destination) {
        assert (source != null && destination != null);
        this.source = source;
        this.destination = destination;
    }

    public ChessBoardCoord getSource() {
        return this.source;
    }

    public ChessBoardCoord getDestination() {
        return this.destination;
    }

    public int get4Distance() {
        return Math.abs(this.source.getRow() - this.destination.getRow()) + Math.abs(this.source.getCol() - this.destination.getCol());
    }

    public int get8Distance() {
        int dx = Math.abs(this.source.getCol() - this.destination.getCol());
        int dy = Math.abs(this.source.getRow() - this.destination.getRow());
        return Math.max(dx, dy);
    }

    public boolean isOverlapping(ChessBoardCoord c) {
        boolean inArea;
        boolean result = false;
        boolean bl = inArea = ChessBoardPath.isInInterval(this.source.getRow(), c.getRow(), this.destination.getRow()) && ChessBoardPath.isInInterval(this.source.getCol(), c.getCol(), this.destination.getCol());
        if (inArea) {
            int dx = Math.abs(this.destination.getCol() - this.source.getCol());
            int dy = Math.abs(this.destination.getRow() - this.source.getRow());
            result = dx == 0 || dy == 0 ? true : (dx == dy ? Math.abs(this.source.getRow() - c.getRow()) == Math.abs(this.source.getCol() - c.getCol()) : (dx > dy ? c.getRow() == this.source.getRow() || c.getCol() == this.destination.getCol() : c.getRow() == this.destination.getRow() || c.getCol() == this.source.getCol()));
        }
        return result;
    }

    private static boolean isInInterval(int min, int x, int max) {
        return Math.min(min, max) <= x && x <= Math.max(min, max);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ChessBoardPath) {
            ChessBoardPath otherPath = (ChessBoardPath)obj;
            result = this.source.equals(otherPath.source) && this.destination.equals(otherPath.destination);
        }
        return result;
    }

    public int hashCode() {
        return this.source.hashCode() + 11 * this.destination.hashCode();
    }

    public String toString() {
        return "Path{" + this.source.getPgnCoordinates() + ":" + this.destination.getPgnCoordinates() + "}";
    }
}

