/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.engine.process;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcess
implements Closeable {
    private Logger log = LoggerFactory.getLogger(ExternalProcess.class);
    private Process process;
    private Writer processWriter;
    private BufferedReader processReader;
    private Timer watchdogTimer;

    public ExternalProcess(long timeout, String ... args) throws IOException {
        this.log.debug("Starting process " + Arrays.toString(args));
        ProcessBuilder pBuilder = new ProcessBuilder(args);
        Map<String, String> env = pBuilder.environment();
        String systemPath = System.getenv("PATH");
        this.log.debug("System path is " + systemPath);
        env.put("PATH", systemPath);
        this.process = pBuilder.start();
        this.watchdogTimer = new Timer();
        this.watchdogTimer.schedule((TimerTask)new InterruptProcessTask(this.process), timeout);
        this.processWriter = new OutputStreamWriter(this.process.getOutputStream());
        this.processReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
    }

    @Override
    public void close() throws IOException {
        this.watchdogTimer.cancel();
        if (this.processWriter != null) {
            this.processWriter.close();
        }
        if (this.process != null) {
            try {
                int code = this.process.waitFor();
                this.log.debug("Process ended with status " + code);
                assert (code == 0);
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while waiting for process to end");
            }
        }
    }

    public void write(String text) throws IOException {
        this.log.debug("Sending data:\n" + text);
        this.processWriter.write(text);
        this.processWriter.flush();
    }

    public String read(Pattern resultPattern, Pattern ... errorPatterns) throws IOException {
        String result = null;
        boolean eof = false;
        do {
            String line = this.processReader.readLine();
            this.log.trace("Process|OUT|{}", (Object)line);
            if (line == null) {
                eof = true;
                continue;
            }
            for (Pattern errorPattern : errorPatterns) {
                Matcher errorMatcher = errorPattern.matcher(line);
                if (!errorMatcher.matches()) continue;
                throw new IOException("External process error: " + line);
            }
            Matcher nextMoveMatcher = resultPattern.matcher(line);
            if (!nextMoveMatcher.matches()) continue;
            result = nextMoveMatcher.group(1);
        } while (result == null && !eof);
        this.log.trace("Process|RES|{}", result);
        return result;
    }

    private class InterruptProcessTask
    extends TimerTask {
        private Process process;

        public InterruptProcessTask(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            ExternalProcess.this.log.warn("Interrupting external process " + this.process);
            this.process.destroy();
        }
    }
}

