/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.engine;

import java.io.IOException;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.alcibiade.chess.engine.ChessEngineController;
import org.alcibiade.chess.engine.ChessEngineFailureException;
import org.alcibiade.chess.engine.process.ExternalProcess;
import org.alcibiade.chess.engine.process.ExternalProcessFactory;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.model.PgnMoveException;
import org.alcibiade.chess.persistence.PgnMarshaller;
import org.alcibiade.chess.persistence.PositionMarshaller;
import org.alcibiade.chess.rules.ChessHelper;
import org.alcibiade.chess.rules.ChessRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="crafty")
public class CraftyEngineImpl
implements ChessEngineController {
    private static final String MYMOVE_PATTERN = ".*\\): (.*)";
    private Logger log = LoggerFactory.getLogger(CraftyEngineImpl.class);
    @Value(value="${crafty.command:crafty}")
    private String craftyCommand;
    @Autowired
    @Qualifier(value="fen")
    private PositionMarshaller fenMarshaller;
    @Autowired
    private ChessRules chessRules;
    @Autowired
    private ExternalProcessFactory externalProcessFactory;
    @Autowired
    private PgnMarshaller pgnMarshaller;

    @PostConstruct
    public void validateCompatibility() throws IOException {
        try (ExternalProcess process = this.externalProcessFactory.run(this.craftyCommand, "log off", "ponder off");){
            String version = process.read(Pattern.compile("Crafty v(.*?) .*", 2), new Pattern[0]);
            process.write("exit\n");
            this.log.info("Detected crafty Chess engine: " + version);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String computeNextMove(int depth, int random, Collection<String> game) throws ChessEngineFailureException {
        Pattern nextMovePattern = Pattern.compile(MYMOVE_PATTERN);
        try (ExternalProcess externalProcess = this.externalProcessFactory.run(this.craftyCommand, "log off", "ponder off", "sd " + depth);){
            ChessPosition position = ChessHelper.movesToPosition(this.chessRules, this.pgnMarshaller, game);
            externalProcess.write("setboard " + this.fenMarshaller.convertPositionToString(position) + "\n");
            externalProcess.write("go\n");
            externalProcess.read(nextMovePattern, new Pattern[0]);
            String nextMove = externalProcess.read(nextMovePattern, new Pattern[0]);
            externalProcess.write("exit\n");
            String string = nextMove;
            return string;
        }
        catch (IOException | PgnMoveException ex) {
            throw new ChessEngineFailureException(ex);
        }
    }

    private String createInputScript(Collection<String> moves, int depth) {
        ChessPosition position = ChessHelper.movesToPosition(this.chessRules, this.pgnMarshaller, moves);
        StringBuilder script = new StringBuilder();
        script.append("setboard ").append(this.fenMarshaller.convertPositionToString(position)).append("\n");
        script.append("go\n");
        return script.toString();
    }
}

