/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model;

import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessBoardPath;
import org.alcibiade.chess.model.ChessPieceType;

public class ChessMovePath
extends ChessBoardPath {
    private static final long serialVersionUID = 1L;
    private ChessPieceType promotedPieceType = ChessPieceType.QUEEN;

    private ChessMovePath() {
    }

    public ChessMovePath(ChessBoardCoord s, ChessBoardCoord d) {
        super(s, d);
    }

    public ChessMovePath(String s, String d) {
        super(s, d);
    }

    public ChessMovePath(ChessBoardCoord s, ChessBoardCoord d, ChessPieceType promotedPieceType) {
        super(s, d);
        this.promotedPieceType = promotedPieceType;
    }

    public ChessMovePath(String s, String d, ChessPieceType promotedPieceType) {
        super(s, d);
        this.promotedPieceType = promotedPieceType;
    }

    public ChessPieceType getPromotedPieceType() {
        return this.promotedPieceType;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ChessMovePath) {
            ChessMovePath oPath = (ChessMovePath)obj;
            result = super.equals(obj) && this.promotedPieceType == oPath.promotedPieceType;
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.promotedPieceType.hashCode();
    }

    @Override
    public String toString() {
        return "ChessMovePath<" + this.getSource().getPgnCoordinates() + ":" + this.getDestination().getPgnCoordinates() + "=" + (Object)((Object)this.promotedPieceType) + ">";
    }
}

