/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model;

import java.io.Serializable;
import org.alcibiade.chess.model.ChessPieceType;
import org.alcibiade.chess.model.ChessSide;

public class ChessPiece
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ChessPieceType type;
    private ChessSide side;

    protected ChessPiece() {
    }

    public ChessPiece(ChessPieceType type, ChessSide side) {
        this.type = type;
        this.side = side;
    }

    public ChessPieceType getType() {
        return this.type;
    }

    public ChessSide getSide() {
        return this.side;
    }

    public String getInitials() {
        return this.side.getShortName() + this.type.getShortName();
    }

    public Character getAsSingleCharacter() {
        Character result = this.type.getShortName();
        if (this.side == ChessSide.WHITE) {
            result = Character.valueOf(Character.toUpperCase(result.charValue()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ChessPiece) {
            ChessPiece oPiece = (ChessPiece)obj;
            result = this.type == oPiece.type && this.side == oPiece.side;
        }
        return result;
    }

    public int hashCode() {
        return this.type.hashCode() + this.side.hashCode();
    }

    public String toString() {
        return this.getInitials();
    }
}

