/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model.boardupdates;

import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessBoardModel;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.boardupdates.AbstractBoardUpdate;

public class PieceUpdateAdd
extends AbstractBoardUpdate {
    private static final long serialVersionUID = 1L;
    private ChessBoardCoord coordinates;
    private ChessPiece piece;

    private PieceUpdateAdd() {
    }

    public PieceUpdateAdd(ChessBoardCoord coordinates, ChessPiece piece) {
        assert (coordinates != null);
        assert (piece != null);
        this.coordinates = coordinates;
        this.piece = piece;
    }

    public ChessBoardCoord getCoordinates() {
        return this.coordinates;
    }

    public ChessPiece getPiece() {
        return this.piece;
    }

    @Override
    public void apply(ChessBoardModel boardModel) {
        assert (boardModel.getPiece(this.coordinates) == null);
        boardModel.setPiece(this.coordinates, this.piece);
    }

    @Override
    public void revert(ChessBoardModel boardModel) {
        assert (boardModel.getPiece(this.coordinates) == this.piece);
        boardModel.setPiece(this.coordinates, null);
    }

    public String toString() {
        return "PieceUpdateAdd " + this.piece + " at " + this.coordinates;
    }
}

