/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.persistence;

import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PgnGameModel {
    private String whitePlayerName;
    private String blackPlayerName;
    private Date gameDate;
    private String result;
    private String event;
    private String site;
    private String round;
    private List<String> moves;

    public PgnGameModel(String whitePlayerName, String blackPlayerName, Date gameDate, String result, String event, String site, String round, List<String> moves) {
        this.whitePlayerName = whitePlayerName;
        this.blackPlayerName = blackPlayerName;
        this.gameDate = gameDate;
        this.moves = moves;
        this.result = result;
        this.event = event;
        this.site = site;
        this.round = round;
    }

    public List<String> getMoves() {
        return Collections.unmodifiableList(this.moves);
    }

    public String getWhitePlayerName() {
        return this.whitePlayerName;
    }

    public String getBlackPlayerName() {
        return this.blackPlayerName;
    }

    public Date getGameDate() {
        return this.gameDate;
    }

    public String getResult() {
        return this.result;
    }

    public String getEvent() {
        return this.event;
    }

    public String getSite() {
        return this.site;
    }

    public String getRound() {
        return this.round;
    }

    public String toString() {
        return String.format("%s vs. %s (%d moves, result: %s)", this.whitePlayerName, this.blackPlayerName, this.moves.size(), this.result);
    }
}

