/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.rules;

import java.util.ArrayList;
import java.util.Collection;
import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.model.ChessSide;
import org.apache.commons.lang.ObjectUtils;

public class PieceLocator {
    private static final ChessBoardCoord[] BOARD_COORDINATES = ChessBoardCoord.getAllBoardCoords().toArray(new ChessBoardCoord[64]);
    private ChessPosition position;

    public PieceLocator(ChessPosition position) {
        this.position = position;
    }

    public Collection<ChessBoardCoord> locatePiece(ChessPiece piece) {
        ArrayList<ChessBoardCoord> coords = new ArrayList<ChessBoardCoord>(4);
        for (ChessBoardCoord coord : BOARD_COORDINATES) {
            ChessPiece localPiece = this.position.getPiece(coord);
            if (!ObjectUtils.equals((Object)piece, (Object)localPiece)) continue;
            coords.add(coord);
        }
        return coords;
    }

    public Collection<ChessBoardCoord> locatePieces(ChessSide side) {
        ArrayList<ChessBoardCoord> coords = new ArrayList<ChessBoardCoord>(18);
        for (ChessBoardCoord coord : BOARD_COORDINATES) {
            ChessPiece localPiece = this.position.getPiece(coord);
            if (localPiece == null || localPiece.getSide() != side) continue;
            coords.add(coord);
        }
        return coords;
    }
}

