/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.alcibiade.chess.engine.ChessEngineAnalyticalController;
import org.alcibiade.chess.engine.ChessEngineFailureException;
import org.alcibiade.chess.engine.EngineAnalysisReport;
import org.alcibiade.chess.engine.process.ExternalProcess;
import org.alcibiade.chess.engine.process.ExternalProcessFactory;
import org.alcibiade.chess.model.ChessMovePath;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.persistence.PgnMarshaller;
import org.alcibiade.chess.rules.ChessHelper;
import org.alcibiade.chess.rules.ChessRules;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="gnuchess")
public class GnuChessEngineImpl
implements ChessEngineAnalyticalController {
    public static final int MATE_SCORE = -10000;
    public static final Pattern MYMOVE_PATTERN = Pattern.compile("My move is : (.*)");
    public static final Pattern ANALYSIS_RESULT_PATTERN = Pattern.compile("^ *\\d+\\.?\\s+([+\\-0-9\\.]+?)\\s+(-?\\d+)\\s+(\\d+)\\s+(.*)");
    private Logger logger = LoggerFactory.getLogger(GnuChessEngineImpl.class);
    private int majorVersion;
    @Value(value="${gnuchess.command:gnuchess}")
    private String gnuchessCommand;
    @Value(value="${gnuchess.analysis.depth:8}")
    private int analysisDepth;
    @Autowired
    private ExternalProcessFactory externalProcessFactory;
    @Autowired
    private ChessRules chessRules;
    @Autowired
    private PgnMarshaller pgnMarshaller;

    @PostConstruct
    public void validateCompatibility() throws IOException {
        block14: {
            try (ExternalProcess process = this.externalProcessFactory.run(this.gnuchessCommand, "--version");){
                String version = process.read(Pattern.compile("(.*)"), new Pattern[0]);
                if (StringUtils.startsWith((String)version, (String)"GNU Chess 5.")) {
                    this.majorVersion = 5;
                    this.logger.info("Detected GnuChess engine: " + version);
                    break block14;
                }
                if (StringUtils.startsWith((String)version, (String)"GNU Chess 6.")) {
                    this.majorVersion = 6;
                    this.logger.info("Detected GnuChess engine: " + version);
                    break block14;
                }
                throw new IllegalStateException("Provided gnuchess not supported: " + version);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String computeNextMove(int depth, int random, Collection<String> game) throws ChessEngineFailureException {
        if (random > 0) {
            throw new IllegalStateException("Randomization not supported in GnuChess");
        }
        String inputScript = this.createInputScript(game, depth);
        try (ExternalProcess externalProcess = this.externalProcessFactory.run(this.gnuchessCommand);){
            externalProcess.write(inputScript);
            String nextMove = externalProcess.read(MYMOVE_PATTERN, new Pattern[0]);
            externalProcess.write("exit\n");
            String string = nextMove;
            return string;
        }
        catch (IOException ex) {
            throw new ChessEngineFailureException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EngineAnalysisReport analyze(Collection<String> moves) throws ChessEngineFailureException {
        String inputScript = this.createAnalysisScript(moves, this.analysisDepth);
        ChessPosition position = ChessHelper.movesToPosition(this.chessRules, this.pgnMarshaller, moves);
        Set<ChessMovePath> availableMoves = this.chessRules.getAvailableMoves(position);
        this.logger.debug("Available moves for analysis are {}", availableMoves);
        if (availableMoves.isEmpty()) {
            return new EngineAnalysisReport(-10000, new ArrayList<String>());
        }
        try (ExternalProcess externalProcess = this.externalProcessFactory.run(this.gnuchessCommand);){
            externalProcess.write(inputScript);
            String[] values = externalProcess.readForArray(ANALYSIS_RESULT_PATTERN, MYMOVE_PATTERN, new Pattern[0]);
            externalProcess.write("exit\n");
            int score = Integer.parseInt(this.majorVersion == 5 ? values[1] : values[0]);
            String variant = values[3];
            String[] variantMoves = StringUtils.split((String)variant);
            List<String> variantList = Arrays.asList(variantMoves);
            EngineAnalysisReport engineAnalysisReport = new EngineAnalysisReport(score, variantList);
            return engineAnalysisReport;
        }
        catch (IOException ex) {
            throw new ChessEngineFailureException(ex);
        }
    }

    private String createInputScript(Collection<String> moves, int depth) {
        StringBuilder script = new StringBuilder();
        script.append("easy\n");
        script.append("force\n");
        script.append("depth ");
        script.append(depth);
        script.append("\n");
        for (String move : moves) {
            script.append(move);
            script.append("\n");
        }
        script.append("go\n");
        return script.toString();
    }

    private String createAnalysisScript(Collection<String> moves, int depth) {
        StringBuilder script = new StringBuilder();
        script.append("easy\n");
        script.append("force\n");
        script.append("post\n");
        script.append("book off\n");
        script.append("depth ");
        script.append(depth);
        script.append("\n");
        for (String move : moves) {
            script.append(move);
            script.append("\n");
        }
        script.append("go\n");
        return script.toString();
    }

    public String toString() {
        return "GnuChessEngineImpl{gnuchessCommand='" + this.gnuchessCommand + '\'' + ", majorVersion=" + this.majorVersion + '}';
    }
}

