/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model;

public enum ChessPieceType {
    PAWN(Character.valueOf('p'), "pawn"),
    KNIGHT(Character.valueOf('n'), "knight"),
    BISHOP(Character.valueOf('b'), "bishop"),
    ROOK(Character.valueOf('r'), "rook"),
    QUEEN(Character.valueOf('q'), "queen"),
    KING(Character.valueOf('k'), "king");

    private final Character shortName;
    private final String fullName;

    private ChessPieceType(Character shortName, String fullName) {
        this.shortName = shortName;
        this.fullName = fullName;
    }

    public static ChessPieceType getPgnType(String s) {
        ChessPieceType result = null;
        for (ChessPieceType type : ChessPieceType.values()) {
            if (type.getShortName().charValue() != s.toLowerCase().charAt(0)) continue;
            result = type;
            break;
        }
        return result;
    }

    public Character getShortName() {
        return this.shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.fullName;
    }
}

