/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model.boardupdates;

import org.alcibiade.chess.model.ChessBoardModel;
import org.alcibiade.chess.model.ChessSide;
import org.alcibiade.chess.model.boardupdates.AbstractBoardUpdate;

public class FlagUpdateCastling
extends AbstractBoardUpdate {
    private static final long serialVersionUID = 1L;
    private ChessSide side;
    private boolean kingside;
    private boolean backup;

    private FlagUpdateCastling() {
    }

    public FlagUpdateCastling(ChessSide side, boolean kingside) {
        this.side = side;
        this.kingside = kingside;
    }

    @Override
    public void apply(ChessBoardModel boardModel) {
        this.backup = boardModel.isCastlingAvailable(this.side, this.kingside);
        boardModel.setCastlingAvailable(this.side, this.kingside, false);
    }

    @Override
    public void revert(ChessBoardModel boardModel) {
        boardModel.setCastlingAvailable(this.side, this.kingside, this.backup);
    }

    public String toString() {
        return "FlagUpdateCastling for " + (Object)((Object)this.side) + " kingside=" + this.kingside;
    }
}

