/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model.boardupdates;

import org.alcibiade.chess.model.ChessBoardModel;
import org.alcibiade.chess.model.ChessBoardPath;
import org.alcibiade.chess.model.boardupdates.AbstractBoardUpdate;

public class PieceUpdateMove
extends AbstractBoardUpdate {
    private static final long serialVersionUID = 1L;
    private ChessBoardPath path;

    private PieceUpdateMove() {
    }

    public PieceUpdateMove(ChessBoardPath path) {
        assert (path != null);
        this.path = path;
    }

    public ChessBoardPath getPath() {
        return this.path;
    }

    @Override
    public void apply(ChessBoardModel boardModel) {
        assert (boardModel.getPiece(this.path.getSource()) != null);
        assert (boardModel.getPiece(this.path.getDestination()) == null);
        boardModel.setPiece(this.path.getDestination(), boardModel.getPiece(this.path.getSource()));
        boardModel.setPiece(this.path.getSource(), null);
    }

    @Override
    public void revert(ChessBoardModel boardModel) {
        assert (boardModel.getPiece(this.path.getSource()) == null);
        assert (boardModel.getPiece(this.path.getDestination()) != null);
        boardModel.setPiece(this.path.getSource(), boardModel.getPiece(this.path.getDestination()));
        boardModel.setPiece(this.path.getDestination(), null);
    }

    public String toString() {
        return "PieceUpdateMove with path " + this.path;
    }
}

