/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.model.boardupdates;

import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessBoardModel;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.boardupdates.AbstractBoardUpdate;

public class PieceUpdateRemove
extends AbstractBoardUpdate {
    private static final long serialVersionUID = 1L;
    private ChessBoardCoord coordinates;
    private ChessPiece removedPiece;

    private PieceUpdateRemove() {
    }

    public PieceUpdateRemove(ChessBoardCoord coordinates) {
        assert (coordinates != null);
        this.coordinates = coordinates;
    }

    public ChessBoardCoord getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void apply(ChessBoardModel boardModel) {
        this.removedPiece = boardModel.getPiece(this.coordinates);
        assert (this.removedPiece != null);
        boardModel.setPiece(this.coordinates, null);
    }

    @Override
    public void revert(ChessBoardModel boardModel) {
        assert (boardModel.getPiece(this.coordinates) == null);
        assert (this.removedPiece != null);
        boardModel.setPiece(this.coordinates, this.removedPiece);
    }

    public String toString() {
        return "PieceUpdateRemove at " + this.coordinates;
    }
}

