/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.persistence;

import org.alcibiade.chess.model.ChessBoardCoord;
import org.alcibiade.chess.model.ChessPiece;
import org.alcibiade.chess.model.ChessPieceType;
import org.alcibiade.chess.model.ChessPosition;
import org.alcibiade.chess.model.ChessSide;

public class FenChessPosition
implements ChessPosition {
    private int moveNumber;
    private int halfMoveClock;
    private ChessSide nextPlayerTurn;
    private ChessBoardCoord lastPawnDMove;
    private ChessPiece[] pieces = new ChessPiece[64];
    private boolean[] castlingFlags = new boolean[4];

    public FenChessPosition(String fen) {
        String[] tokens = fen.split(" ");
        String[] rows = tokens[0].split("/");
        for (int i = 0; i < rows.length; ++i) {
            int colIndex = 0;
            for (char c : rows[i].toCharArray()) {
                ChessPieceType cpt = ChessPieceType.getPgnType("" + c);
                if (cpt != null) {
                    this.pieces[(7 - i) * 8 + colIndex] = new ChessPiece(cpt, this.isUpperCase(c) ? ChessSide.WHITE : ChessSide.BLACK);
                    ++colIndex;
                    continue;
                }
                colIndex += Integer.parseInt("" + c);
            }
        }
        this.nextPlayerTurn = "w".equals(tokens[1]) ? ChessSide.WHITE : ChessSide.BLACK;
        block8: for (char c : tokens[2].toCharArray()) {
            switch (c) {
                case 'K': {
                    this.castlingFlags[0] = true;
                    continue block8;
                }
                case 'Q': {
                    this.castlingFlags[1] = true;
                    continue block8;
                }
                case 'k': {
                    this.castlingFlags[2] = true;
                    continue block8;
                }
                case 'q': {
                    this.castlingFlags[3] = true;
                }
            }
        }
        this.lastPawnDMove = "-".equals(tokens[3]) ? null : new ChessBoardCoord(tokens[3]).add(0, this.getNextPlayerTurn() == ChessSide.WHITE ? -1 : 1);
        this.halfMoveClock = Integer.parseInt(tokens[4]);
        this.moveNumber = Integer.parseInt(tokens[5]);
    }

    private boolean isUpperCase(char c) {
        return ("" + c).toUpperCase().equals("" + c);
    }

    @Override
    public int getMoveNumber() {
        return this.moveNumber;
    }

    @Override
    public int getHalfMoveClock() {
        return this.halfMoveClock;
    }

    @Override
    public ChessPiece getPiece(ChessBoardCoord coordinates) {
        return this.pieces[coordinates.getOffset()];
    }

    @Override
    public boolean isCastlingAvailable(ChessSide side, boolean kingside) {
        switch (side) {
            case WHITE: {
                return kingside ? this.castlingFlags[0] : this.castlingFlags[1];
            }
            case BLACK: {
                return kingside ? this.castlingFlags[2] : this.castlingFlags[3];
            }
        }
        return false;
    }

    @Override
    public ChessSide getNextPlayerTurn() {
        return this.nextPlayerTurn;
    }

    @Override
    public ChessBoardCoord getLastPawnDMove() {
        return this.lastPawnDMove;
    }
}

