/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.chess.persistence;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alcibiade.chess.persistence.PgnGameModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PgnBookReader
implements Closeable {
    private Logger log = LoggerFactory.getLogger(PgnBookReader.class);
    private BufferedReader bookReader;

    public PgnBookReader(InputStream bookStream) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(bookStream, "UTF-8");
        this.bookReader = new BufferedReader(reader);
    }

    @Override
    public void close() throws IOException {
        this.bookReader.close();
    }

    public PgnGameModel readGame() throws IOException {
        Pattern header = Pattern.compile("\\[(.*) \"(.*)\"\\]");
        String whitePlayerName = "White player";
        String blackPlayerName = "Black player";
        String result = "*";
        String event = null;
        String site = null;
        String round = null;
        Date gameDate = new Date();
        LinkedList<String> moves = new LinkedList<String>();
        boolean inComment = false;
        String line = this.bookReader.readLine();
        while (line != null) {
            block8: {
                String[] tokens;
                String preprocessed;
                block7: {
                    String val;
                    block9: {
                        String key;
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        preprocessed = this.preprocess(line);
                                        if (!moves.isEmpty() && preprocessed.isEmpty()) break;
                                        Matcher headerMatcher = header.matcher(preprocessed);
                                        if (!headerMatcher.matches()) break block7;
                                        key = headerMatcher.group(1);
                                        val = headerMatcher.group(2);
                                        this.log.debug("" + key + " = " + val);
                                        if ("?".equals(val)) break block8;
                                        if ("white".equalsIgnoreCase(key)) break block9;
                                        if (!"black".equalsIgnoreCase(key)) break block10;
                                        blackPlayerName = val;
                                        break block8;
                                    }
                                    if ("date".equalsIgnoreCase(key)) {
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");
                                        try {
                                            gameDate = df.parse(val.replaceAll("\\?\\?", "01"));
                                        }
                                        catch (ParseException e) {
                                            throw new IOException("Invalid date format in pgn header " + e);
                                        }
                                    }
                                    if (!"result".equalsIgnoreCase(key)) break block11;
                                    result = val;
                                    break block8;
                                }
                                if (!"site".equalsIgnoreCase(key)) break block12;
                                site = val;
                                break block8;
                            }
                            if (!"event".equalsIgnoreCase(key)) break block13;
                            event = val;
                            break block8;
                        }
                        if (!"round".equalsIgnoreCase(key)) break block8;
                        round = val;
                        break block8;
                    }
                    whitePlayerName = val;
                    break block8;
                }
                for (String token : tokens = preprocessed.replaceAll("(^| )[0-9]+\\.", " ").split(" +")) {
                    if (token.contains("{")) {
                        inComment = true;
                    }
                    if (token.contains("}")) {
                        inComment = false;
                        continue;
                    }
                    if (inComment || StringUtils.isEmpty((Object)token) || !Character.isLetter(token.charAt(0))) continue;
                    moves.add(token);
                }
            }
            line = this.bookReader.readLine();
        }
        return moves.isEmpty() ? null : new PgnGameModel(whitePlayerName, blackPlayerName, gameDate, result, event, site, round, moves);
    }

    private String preprocess(String line) {
        String result = line.trim();
        if (!result.startsWith("[")) {
            result = result.replaceAll("\\{.*?\\}", "");
        }
        return result;
    }
}

