/*
 * Decompiled with CFR 0.152.
 */
package org.alexmond.jsupervisor.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.alexmond.jsupervisor.config.SupervisorConfig;
import org.alexmond.jsupervisor.model.ProcessStatusRest;
import org.alexmond.jsupervisor.repository.ProcessRepository;
import org.alexmond.jsupervisor.service.ProcessManager;
import org.alexmond.jsupervisor.service.ProcessManagerBulk;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Supervisor", description="Process API")
@RestController
@RequestMapping(value={"/api/v1"})
public class RestProcessController {
    final SupervisorConfig supervisorConfig;
    private final AtomicInteger counter = new AtomicInteger();
    private final ProcessRepository processRepository;
    private final ProcessManager processManager;
    private final ProcessManagerBulk processManagerBulk;

    @Autowired
    public RestProcessController(ProcessRepository processRepository, SupervisorConfig supervisorConfig, ProcessManager processManager, ProcessManagerBulk processManagerBulk) {
        this.processRepository = processRepository;
        this.supervisorConfig = supervisorConfig;
        this.processManager = processManager;
        this.processManagerBulk = processManagerBulk;
    }

    @PostMapping(value={"/startAll"})
    @Operation(summary="Start all configured processes")
    @ApiResponse(responseCode="200", description="All processes started successfully")
    public void startAllProcess() throws IOException {
        this.processManagerBulk.startAll();
    }

    @PostMapping(value={"/stop/{name}"})
    @Operation(summary="Stop a specific process")
    @ApiResponse(responseCode="200", description="Process stopped successfully")
    public void stopProcess(@PathVariable String name) {
        this.processManager.stopProcess(name);
    }

    @PostMapping(value={"/start/{name}"})
    @Operation(summary="Start a specific process")
    @ApiResponse(responseCode="200", description="Process started successfully")
    public void startProcess(@PathVariable String name) {
        this.processManager.startProcess(name);
    }

    @PostMapping(value={"/restart/{name}"})
    @Operation(summary="Restart a specific process")
    @ApiResponse(responseCode="200", description="Process started successfully")
    @GetMapping(value={"/restart/{name}"})
    public void restartProcess(@PathVariable String name) {
        this.processManager.restartProcess(name);
    }

    @PostMapping(value={"/details/{name}"})
    @Operation(summary="Return the details for a specific process")
    @ApiResponse(responseCode="200", description="Details returned successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProcessStatusRest.class))})
    public ProcessStatusRest processesDetails(@PathVariable String name) {
        return new ProcessStatusRest(name, this.processRepository.getRunningProcess(name));
    }

    @GetMapping(value={"/allProcesses"})
    @Operation(summary="Get all configured processes")
    @ApiResponse(responseCode="200", description="List of all processes retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProcessStatusRest.class))})
    public Collection<ProcessStatusRest> getAllProcesses() {
        return this.processRepository.findAllProcessStatusRest();
    }
}

