/*
 * Decompiled with CFR 0.152.
 */
package org.alexmond.jsupervisor.ui.controller;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import lombok.Generated;
import org.alexmond.jsupervisor.config.SupervisorConfig;
import org.alexmond.jsupervisor.model.ProcessStatusRest;
import org.alexmond.jsupervisor.repository.EventRepository;
import org.alexmond.jsupervisor.repository.ProcessRepository;
import org.alexmond.jsupervisor.repository.RunningProcess;
import org.alexmond.jsupervisor.service.ProcessManager;
import org.alexmond.jsupervisor.service.ProcessManagerBulk;
import org.alexmond.jsupervisor.ui.model.BaseModel;
import org.alexmond.jsupervisor.ui.model.EventsPageModel;
import org.alexmond.jsupervisor.ui.model.ProcessDetailPageModel;
import org.alexmond.jsupervisor.ui.model.ProcessLogPageModel;
import org.alexmond.jsupervisor.ui.model.ProcessesPageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/"})
public class WebProcessController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebProcessController.class);
    private final ProcessRepository processRepository;
    private final ProcessManager processManager;
    private final ProcessManagerBulk processManagerBulk;
    private final SupervisorConfig supervisorConfig;
    private final EventRepository eventRepository;
    private final boolean linkToPage = false;

    @GetMapping(value={"/", "/index"})
    public String getAllProcesses(Model model) {
        Collection processes = this.processRepository.findAllProcessStatusRest();
        BaseModel pageModel = ((ProcessesPageModel.ProcessesPageModelBuilder)((ProcessesPageModel.ProcessesPageModelBuilder)((ProcessesPageModel.ProcessesPageModelBuilder)ProcessesPageModel.builder().title("Process List")).activePage("processes")).processes(processes)).build();
        model.addAttribute("pageModel", (Object)pageModel);
        model.addAttribute("content", (Object)"proc/list");
        return "layout";
    }

    @GetMapping(value={"/start/{name}"})
    public String startProcess(@PathVariable String name) {
        this.processManager.startProcess(name);
        return "redirect:/";
    }

    @GetMapping(value={"/stop/{name}"})
    public String stopProcess(@PathVariable String name) {
        this.processManager.stopProcess(name);
        return "redirect:/";
    }

    @GetMapping(value={"/restart/{name}"})
    public String restartProcess(@PathVariable String name) {
        this.processManager.restartProcess(name);
        return "redirect:/";
    }

    @GetMapping(value={"/startAll"})
    public String startAll() throws IOException {
        this.processManagerBulk.startAll();
        return "redirect:/";
    }

    @GetMapping(value={"/stopAll"})
    public String stopAll() throws IOException {
        this.processManagerBulk.stopAll();
        return "redirect:/";
    }

    @GetMapping(value={"/details/{name}"})
    public String processesDetails(@PathVariable String name, Model model) {
        ProcessStatusRest proc = new ProcessStatusRest(name, this.processRepository.getRunningProcess(name));
        BaseModel pageModel = ((ProcessDetailPageModel.ProcessDetailPageModelBuilder)((ProcessDetailPageModel.ProcessDetailPageModelBuilder)((ProcessDetailPageModel.ProcessDetailPageModelBuilder)ProcessDetailPageModel.builder().title("Process Details")).activePage("processes")).proc(proc)).build();
        model.addAttribute("pageModel", (Object)pageModel);
        model.addAttribute("content", (Object)"proc/detail");
        return "layout";
    }

    @GetMapping(value={"/log/{name}"})
    public String processLog(@PathVariable String name, @RequestParam(defaultValue="stdout") String type, @RequestParam(defaultValue="100") int lines, Model model) throws IOException {
        RunningProcess runningProcess = this.processRepository.getRunningProcess(name);
        if (runningProcess == null) {
            model.addAttribute("error", (Object)("Process not found: " + name));
            return "logs/error";
        }
        File logFile = "stderr".equals(type) ? runningProcess.getStderr() : runningProcess.getStdout();
        String logContent = "";
        if (runningProcess.getStdout() != null && runningProcess.getStdout().exists()) {
            logContent = Files.readString(runningProcess.getStdout().toPath());
        }
        ProcessStatusRest proc = new ProcessStatusRest(name, this.processRepository.getRunningProcess(name));
        BaseModel pageModel = ((ProcessLogPageModel.ProcessLogPageModelBuilder)((ProcessLogPageModel.ProcessLogPageModelBuilder)((ProcessLogPageModel.ProcessLogPageModelBuilder)((ProcessLogPageModel.ProcessLogPageModelBuilder)((ProcessLogPageModel.ProcessLogPageModelBuilder)((ProcessLogPageModel.ProcessLogPageModelBuilder)((ProcessLogPageModel.ProcessLogPageModelBuilder)ProcessLogPageModel.builder().title("Process Log")).activePage("processes")).logType(type)).logFile(logFile != null ? logFile.getName() : "N/A")).lines(lines)).logContent(logContent)).pr(proc)).build();
        model.addAttribute("pageModel", (Object)pageModel);
        model.addAttribute("content", (Object)"proc/process-log");
        return "layout";
    }

    @GetMapping(value={"/events"})
    public String getEvents(Model model) {
        BaseModel pageModel = ((EventsPageModel.EventsPageModelBuilder)((EventsPageModel.EventsPageModelBuilder)((EventsPageModel.EventsPageModelBuilder)EventsPageModel.builder().title("Events")).activePage("events")).events(this.eventRepository.findAll())).build();
        model.addAttribute("pageModel", (Object)pageModel);
        model.addAttribute("content", (Object)"proc/events");
        return "layout";
    }

    @Generated
    public WebProcessController(ProcessRepository processRepository, ProcessManager processManager, ProcessManagerBulk processManagerBulk, SupervisorConfig supervisorConfig, EventRepository eventRepository) {
        this.processRepository = processRepository;
        this.processManager = processManager;
        this.processManagerBulk = processManagerBulk;
        this.supervisorConfig = supervisorConfig;
        this.eventRepository = eventRepository;
    }
}

