/*
 * Decompiled with CFR 0.152.
 */
package org.alexmond.yaml.validator;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.alexmond.yaml.validator.YamlSchemaValidator;
import org.alexmond.yaml.validator.config.ReportType;
import org.alexmond.yaml.validator.config.YamlSchemaValidatorConfig;
import org.alexmond.yaml.validator.output.FilesOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class YamlSchemaValidatorRunner
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YamlSchemaValidatorRunner.class);
    private final YamlSchemaValidatorConfig config;
    private final YamlSchemaValidator yamlSchemaValidator;
    private final Environment environment;

    public void run(ApplicationArguments args) {
        if (this.environment.matchesProfiles(new String[]{"test"})) {
            return;
        }
        log.warn(args.toString());
        if (args.containsOption("help")) {
            this.printHelp();
            System.exit(0);
            return;
        }
        String configError = this.validateConfig(args);
        if (configError != null) {
            System.out.println("Configuration error:" + configError);
            this.printHelp();
            System.exit(1);
            return;
        }
        LinkedHashMap allResultsl = new LinkedHashMap();
        args.getNonOptionArgs().forEach(file -> {
            try {
                Map result = this.yamlSchemaValidator.validate(file, this.config.getSchema());
                allResultsl.putAll(result);
            }
            catch (RuntimeException e) {
                log.error("Unexpected error during validation", (Throwable)e);
            }
        });
        FilesOutput filesOutput = new FilesOutput(allResultsl);
        if (this.config.getReportType() == ReportType.TEXT) {
            System.out.println(filesOutput.toColoredString(this.config.isColorOutput()));
        } else {
            System.out.println(filesOutput.toJsonString());
        }
        if (filesOutput.isValid()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private void printHelp() {
        String helpText = "Usage: java -jar yaml-schema-validator.jar [options] <file1> <file2> ...\n\nOptions:\n  --schema=<path>          Path to the JSON schema file (required unless schemaPathOverride is false)\n  --schemaPathOverride     If set, the schema path must be provided via --schema option\n  --help                   Show this help message\n";
        System.out.println(helpText);
        System.exit(0);
    }

    private String validateConfig(ApplicationArguments args) {
        if (args.getNonOptionArgs().isEmpty()) {
            return "At least one YAML/JSON file must be provided as a non-option argument";
        }
        if (this.config.isSchemaPathOverride() && this.config.getSchema() == null) {
            return "Schema path must be provided when schemaPathOverride is enabled";
        }
        return null;
    }

    @Generated
    public YamlSchemaValidatorRunner(YamlSchemaValidatorConfig config, YamlSchemaValidator yamlSchemaValidator, Environment environment) {
        this.config = config;
        this.yamlSchemaValidator = yamlSchemaValidator;
        this.environment = environment;
    }
}

