/*
 * Decompiled with CFR 0.152.
 */
package org.alexmond.yaml.validator.output;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.output.OutputUnit;
import java.util.Map;
import lombok.Generated;
import org.alexmond.yaml.validator.output.FilesOutputToJunit;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonRootName(value="")
@JsonPropertyOrder(value={"valid", "files"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FilesOutput {
    private boolean valid;
    private Map<String, OutputUnit> files;

    public FilesOutput(Map<String, OutputUnit> files) {
        this.files = files;
        this.valid = files.values().stream().allMatch(OutputUnit::isValid);
    }

    public String toColoredString(boolean color) {
        String ansiReset;
        String ansiRed;
        String ansiGreen;
        if (!color) {
            ansiGreen = "";
            ansiRed = "";
            ansiReset = "";
        } else {
            ansiReset = "\u001b[0m";
            ansiRed = "\u001b[31m";
            ansiGreen = "\u001b[32m";
        }
        StringBuilder result = new StringBuilder();
        result.append("Validation Result: ");
        result.append(this.valid ? ansiGreen + "ok" : ansiRed + "invalid").append(ansiReset).append("\n");
        this.files.forEach((filename, output) -> {
            result.append((String)filename).append(": ");
            result.append(output.isValid() ? ansiGreen + "ok" : ansiRed + "invalid").append(ansiReset).append("\n");
            if (!output.isValid() && output.getErrors() != null) {
                output.getErrors().forEach((label, message) -> result.append("  " + label + ": ").append(message).append("\n"));
            }
            if (!output.isValid() && output.getDetails() != null) {
                output.getDetails().forEach(detail -> {
                    result.append("  Details:\n");
                    result.append("    Path: ").append(detail.getInstanceLocation()).append("\n");
                    result.append("    Schema: ").append(detail.getSchemaLocation()).append("\n");
                    if (detail.getErrors() != null) {
                        detail.getErrors().forEach((label, message) -> result.append("    ").append((String)label).append(": ").append(message).append("\n"));
                    }
                });
            }
        });
        return result.toString();
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting to JSON", e);
        }
    }

    public String toYamlString() {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting to YAML", e);
        }
    }

    public String toJunitString() {
        FilesOutputToJunit junitOutput = new FilesOutputToJunit(this.files);
        return junitOutput.toJunitString();
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public Map<String, OutputUnit> getFiles() {
        return this.files;
    }

    @Generated
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Generated
    public void setFiles(Map<String, OutputUnit> files) {
        this.files = files;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesOutput)) {
            return false;
        }
        FilesOutput other = (FilesOutput)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        Map this$files = this.getFiles();
        Map other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FilesOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        Map $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FilesOutput(valid=" + this.isValid() + ", files=" + String.valueOf(this.getFiles()) + ")";
    }
}

